

% function [t0,t1,n0,n1] = support(p,delta)
% 
% Determines start and end of a sampled signal p according 
% to threshold parameter delta
%
% t0,t1 are the the start and stop times with respect to p.d
% n0,n1 are the indices associated with the start and stop 
%
% Synopsis:
%
% 	[t0,t1,n0,n1] = support(p,delta) 
% 	[t0,t1] = 	support(p,delta) 


function [tl,tr,nl,nr] = support(p,delta)

% argument processing

   if nargin<2, delta=0.01; end
	
   p=normalize(abs(p),inf);
	
   [rows,cols] = size(p.sig);
	
   tl=repmat(NaN,1,cols);
   tr=tl;
   nl=tl;
   nr=tl;
	
   for jj=1:cols
     sig = p.sig(:,jj);
	  
     ii = find(sig>delta);
     
     if ~isempty(ii)
	  
       nl(jj) = ii(1);   % index after  delta crossing
       nr(jj) = ii(end); % index before delta crossing
       
       % fractional index a la quadratic interpolation

       indl = nl(jj)+[-1 0 1];
       indl = max(indl,1);
       indl = min(indl,rows);

       indr = nr(jj)+[-1 0 1];
       indr = max(indr,1);
       indr = min(indr,rows);

       yl = sig(indl); % the two values that cross at delta
       yr = sig(indr); % the two values that cross at delta
       
       tl(jj)=(nl(jj)-n0(p)+min(quadcross(yl,delta)))*p.d(1);
       tr(jj)=(nr(jj)-n0(p)+max(quadcross(yr,delta)))*p.d(1);
       
     end
   end
	
%
%
%

function t=lincross(y,delta)
	
% x = [0 1]

   t = (delta-y(1))/(y(2)-y(1));
   
%
%
%

function t=quadcross(y,delta,sgn)

% length(y) must be 3
% x = [-1 0 1];
%
% t should have one positive root and one negative (both real)

   if any(isnan(y)), t=NaN; return, end

   Minv = [ 0.5 -1 0.5; -0.5 0 0.5; 0 1 0 ];
	
   coefs = Minv*y(:);
   coefs(3) = coefs(3)-delta;

   if coefs(1)~=0
     t = (-coefs(2) + [-1 1]*sqrt(coefs(2)^2 ...
	 - 4*coefs(1)*coefs(3)))/(2*coefs(1));
     
     t = real(t); % should be real
     t = t(find(t>-1 & t<1));
     if isempty(t), t=0; end
   else
     t=0;
   end
   
   

	
