

% function [t0,t1,n0,n1] = support_lin(p,delta)
% 
% Determines start and end of a sampled signal p according 
% to threshold parameter delta
%
% t0,t1 are the the start and stop times with respect to p.d
% n0,n1 are the indices associated with the start and stop 
%
% Synopsis:
%
% 	[t0,t1,n0,n1] = support(p,delta) 
% 	[t0,t1] = 	support(p,delta) 


function [tl,tr,nl,nr] = support_lin(p,delta)

% argument processing

	if nargin<2, delta=0.01; end
	
	p=normalize(abs(p),inf);
	
	cols = size(p.sig,2);
	
	nl=zeros(1,cols);
	nr=zeros(1,cols);
	
	for jj=1:cols
	  sig = p.sig(:,jj);
	  
	  ii = find(sig>delta);
	  
	  nl(jj) = ii(1)-1; % index before  delta crossing
	  nr(jj) = ii(end); % index before delta crossing
	  
	  % fractional index a la linear or quadratic interpolation
	  
	  yl = sig(nl(jj)+[0 1]); % the two values that cross at delta
	  yr = sig(nr(jj)+[0 1]); % the two values that cross at delta
	  
	  tl(jj)=(nl(jj)-n0(p)+lincross(yl,delta))*p.d(1);
	  tr(jj)=(nr(jj)-n0(p)+lincross(yr,delta))*p.d(1);
	  
	  %nlfrac(jj) = (delta-yl(1))/diff(yl) - 1;
	  %nrfrac(jj) = (delta-yr(1))/diff(yr);
	end
	
	%tl = (nl+nlfrac-n0(p))*p.d(1);
	%tr = (nr+nrfrac-n0(p))*p.d(1);
%
%
%

function t=lincross(y,delta)
	
% x = [0 1]

   t = (delta-y(1))/(y(2)-y(1));
   
%
%
%

function t=quadcross(y,delta)
	
% length(y) must be 3
% x = [-1 0 1];

   Minv = [ 0.5 -1 0.5; -0.5 0 0.5; 0 1 0 ];
	
   coefs = Minv*y(:);
   coefs(3) = coefs(3)-delta;

   %t = roots(coefs);
   
   t = (-coefs(2) + [-1 1]*sqrt(coefs(2)^2 - 4*coefs(1)*coefs(3)))/(2*coefs(1));
   t = t(find(t>=-1 & t<=1));


   
   

	
