
function p = threshold(p,delta,how)

% function p = threshold(p,delta,how)
%
% Threshold signal based on delta percentage 
% of the max magnitude of sig
%
% The optional input argument, how, controls how
% the threshold is interpreted
%
%    how = 'absolute' or ['relative']
%
% A value of 'relative' interprets the threshold relative
% to the maximum

% arg process

   if nargin<3, how='relative'; end
   
% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),delta,how);
   end
   

% scalar case

function p=scalar(p,delta,how)

   if strcmp(how,'relative')
     thresh = delta*max(abs(p.sig(:))); 
   else
     thresh = delta;
   end
   
% apply delta threshold

   ii=find(abs(p.sig(:))<thresh);
   p.sig(ii) = zeros(size(ii));

% name

   if strcmp(p.nametrack,'on')
     if strcmp(how,'relative')
       p.name = sprintf('F''_{%s}%s',num2str(delta),p.name);
     else
       p.name = sprintf('F_{%s}%s',num2str(delta),p.name);       
     end
   end


   
