
function [p,dx]=time_align(p,x0)

% function p=time_align(p,x0)
%
%   Align signals in p to the value x0
%   based on 6dB points
%
% See Also align.m


  if exist('cinterp')==3
    dn = x0/p.d(1);
    if ~isint(dn)
      disp('WARNING: Fractional offset ignored.')
      dn = round(dn);
    end
    [p.sig,dx] = cinterp(p.sig,0.25,'thresh',n0(p)+dn);p
  else
    [p,dx]=align(p,x0,0.25);
  end