
function p = translate(p,t0)

% function p = translate(p,t0)
%
%   Translate sampled signal by t0
%
%   Signals are cyclically translated in the interval p.d
%   with resampling  if necessary


% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),t0);
   end
   

% scalar case

function p=scalar(p,t0)

   p = resample(p,p.d,t0);
   
   if strcmp(p.nametrack,'on')
     p.name = sprintf('\\tau_{%s}%s',num2str(t0),p.name);
   end
   
	
   