
function [W,f]=uiFWTDisp(W,f)

% function uiFWTDisp(W,f)
%
% Display DWT in various formats as indicated by mode
%

% init

   win_name = sprintf('fwt: %s',f.name);
   panel_sep=[1.05];
   clf
   
   
   fig = findobj('Name',win_name);
   fig=[];
   if length(fig)==0
     %pop 100, clf
     set(gcf,'Name',win_name)
     
     % where to start placing controls

     SetControlPos([0.025 0.15 0.12 0.05])

     % the panels

     [hGframe,hGui] = FramePanel;
     [hframe,hui] = FramePanel;   
       h1=NewControl('pushbutton','v',[...
	   'HideControls,'...
	   'fwtdisp(GetUserData(''W'')),'...
	   'hd=NewControl(''pushbutton'',''^'');'...
           'set(hd,''position'',[0.01 0.01 0.04 0.04]),'...
           'set(hd,''callback'',''ShowControls, fwtdisp(GetUserData(''''W''''))''),'...
           'set(hd,''tag'',''delete''),'...
	   'h=NewControl(''pushbutton'',''Pr'');'...
           'set(h,''position'',[0.01 0.06 0.04 0.04]),'...
           'set(h,''callback'',''print_fwt''),'...
           'set(h,''tag'',''delete''),'...
	   'clear h hd'...
       ]);
       hD=NewControl('pushbutton','Display','fwtdisp(GetUserData(''W''))');
       MoveRelPos(hD,h1,'up',1.3)
     FramePanel(hframe,hui);       
       
     [hframe,hui] = FramePanel;
       hs = NewControl(...
                'popupmenu',...
                'X Fac',...
                '',...
                1,...
                '1|2|5|10|20|50|100'...
       );
       MoveRelPos(hs,hui,'up',2)
       
       hm = NewControl(...
                'popupmenu',...
                'mode',...
                '',...
                1,...
                'real|abs|imag|complex|angle'...
       );
       MoveRelPos(hm,hs,'up')
     FramePanel(hframe,hui);   
       
     [hframe,hui] = FramePanel;
       hp = NewControl(...
                'checkbox',...
                'points',...
                '',...
                0,...
                'points'...
       );
       MoveRelPos(hp,hui,'up',panel_sep)
       
       hTS = NewControl(...
                'checkbox',...
                'T/S',...
                '',...
                1,...
                'T/S'...
       );
       MoveRelPos(hTS,hp,'up',1)
     FramePanel(hframe,hui);   


     [hframe,hui] = FramePanel;
       h=NewControl('text','FWT View');
       set(h,'BackGroundColor',get(hGframe,'BackGroundColor'))
       set(h,'ForeGroundColor',[0.3 0 0])
       MoveRelPos(h,hui,'up',panel_sep)
     FramePanel(hframe,hui);
  
     FramePanel(hGframe,findobj('style','frame'),0.02);
     
    setplot set
      
% hidden figure variables

    [coarse_scale fine_scale]=module_input('fwt');
    name = module_input('DWTProc');
    
    SetUserData('W',W)
    SetUserData('f',f)
    
    SetUserData('name',name)
    SetUserData('scales',[coarse_scale fine_scale])
     
       
   else
     figure(fig)   
   end
   
   fwtdisp(W,f)
