
function p=unbfrq(p)

% matrix case

    for ii=1:length(p(:))
      p(ii)=scalar(p(ii));
    end

    
%  scalar case

function freq=scalar(p)

   % compute the frequency

   phase = unwrap(angle(p));	
   freq  = der(phase)./(2*pi);
   
   % remove the mean along the 3dB pts

   p3dB = normalize(abs(p),inf)>0.5;
   for ii=1:size(freq.sig,2)
     ind = find(p3dB.sig(:,ii));
     
     freq.sig(:,ii) = freq.sig(:,ii) - mean(freq.sig(ind,ii));
   end
   
   % label
					      
   freq.name   = sprintf('UNBFRQ(%s)',p.name);
   freq.ylabel = GetGlobal('FreqLabel','default','Freq (MHz)');

  % win12dB = name(normalize(abs(p),inf)>0.125,'win12dB');
   win12dB = name(normalize(abs(p),inf)>0.5,'win3dB');
   freq    = freq.*win12dB;
