
function f = upcell(Hf,Lf, h,g)

% function [f,fd] = upcell(Hf,Lf, h,g)
%
% INPUT:
%       Hf    high pass sampled signal 
%       Lf    low  pass sampled signal 
%       h,g   qmf filter pair
%
% OUTPUT:
%       f     sampled signal 

% involuted filters for reconstruction

   h = flipud(conj(h));
   g = flipud(conj(g));

% upsample

   Lf2 = upsample(Lf);
   Hf2 = upsample(Hf);

% pass through synthesis filters and add

   f  = mconv(Lf2,h) + mconv(Hf2,g); 
