
function p = upsample(p,upfactor,start)

% function p = upsample(p,upfactor)
%
% INPUT:
%    p         sampled signal matrix pair
%    upfactor  integer factor by which to upsample [ 2 ]
% 
% OUTPUT:
%    upsampled by factor of upfactor signal matrix pair

% arg process

   if nargin<2, upfactor=2; end
   if nargin<3, start=2; end

% do it

  for ii=1:length(p)
    p(ii) = scalar(p(ii),upfactor,start);
  end
  
%
%
%

function p=scalar(p,upfactor,start)
% init

   [rows,cols] = size(p.sig);

% allocate memory for upsampled signal matrix

   sig  = zeros(upfactor*rows,cols);

% upsample

   sig(start:upfactor:upfactor*rows,:) = p.sig;
   
   p.sig = sig;
   p.d   = [ p.d(1)/upfactor p.d(2) ];

   p.name = sprintf('S^{+}_%s %s',num2str(upfactor),p.name);
