
function  WW=wfft(p,log2wsize,overlap)

% function  W=wfft(p,log2wsize,overlap)
%
% windowed fft

  if nargin<2, log2wsize=10; end
  if nargin<3, overlap=1; end

% scalar case

  wsize = 2^log2wsize;  
  
  p=zeropad(p);
  
  for ii=1:overlap
    
    W(ii) = wfft_partition(p,wsize);
    p.sig = shift(p.sig,-wsize/overlap,'r');
    
  end

  [rows,cols] = size(W(1).sig);
  
  sig=zeros(rows,overlap,cols);
  for ii=1:overlap
    sig(:,ii,:) = W(ii).sig;
  end 
  
  WW=W(1);
  WW.sig = reshape(sig,rows,cols*overlap);
  WW.d   = WW.d .* [1/overlap 1];
  
  WW = WW.';
  
  
function W=wfft_partition(p,wsize)
  
  nffts = size(p.sig,1)/wsize;
  p.sig = reshape(p.sig,wsize,nffts,size(p.sig,2));
  
  nffts = size(p.sig,2)
  
  pd  =  p.d;
  p.d = [p.d(1) p.d(2)/nffts];
  
  W = fft(p);
  
  W.name = sprintf('wfft(%s)',p.name);
  
  W.sig  = reshape(W.sig,size(p.sig));
  
  
  if 1
    W.sig(1:size(W.sig,1)/2,:,:) = [];
    W.d(2)=W.d(2)/2;
    W.d0  = p.d0;
  
    W.dy     = [pd(1)*wsize pd(2)];
    W.dy0    = 1;
    W.ylabel = p.xlabel;
    
  %  W = W.';
  end



  
  
function old
  
  wsize = 2^log2wsize;  
  
  p=zeropad(p);
  
  nffts = size(p.sig,1)/wsize;
  p.sig = reshape(p.sig,wsize,nffts,size(p.sig,2));
  
  p.sig = p.sig(:,1:overlap:end);
  
  nffts = size(p.sig,2)
  
  pd  =  p.d;
  p.d = [p.d(1)*overlap p.d(2)/nffts];
  
  W = fft(p);
  
  W.name = sprintf('wfft(%s)',p.name);
  
  W.sig  = reshape(W.sig,size(p.sig));
  
  if 1
    W.sig(1:size(W.sig,1)/2,:,:) = [];
    W.d(2)=W.d(2)/2;
    W.d0  = p.d0;
  
    W.dy     = [pd(1)*wsize pd(2)];
    W.dy0    = 1;
    W.ylabel = p.xlabel;
    
    W = W.';
  end

  wsize = 2^log2wsize;  
  
  p=zeropad(p);
  
  nffts = size(p.sig,1)/wsize;
  p.sig = reshape(p.sig,wsize,nffts,size(p.sig,2));
  
  p.sig = p.sig(:,1:overlap:end);
  
  nffts = size(p.sig,2)
  
  pd  =  p.d;
  p.d = [p.d(1)*overlap p.d(2)/nffts];
  
  W = fft(p);
  
  W.name = sprintf('wfft(%s)',p.name);
  
  W.sig  = reshape(W.sig,size(p.sig));
  
  if 1
    W.sig(1:size(W.sig,1)/2,:,:) = [];
    W.d(2)=W.d(2)/2;
    W.d0  = p.d0;
  
    W.dy     = [pd(1)*wsize pd(2)];
    W.dy0    = 1;
    W.ylabel = p.xlabel;
    
    W = W.';
  end
