
function [Wp,FB]=wpt(p,pts)

% adaptive wavelet packet transform

  if nargin<2
    pts = 0.1:0.05:1.1;
    pts = pts.^2;
    
    pts = [ -fliplr(pts(2:end))    pts(1:end-1); ...
            -fliplr(pts(1:end-1))  pts(2:end) ];

  end

  
  for ii=1:length(p(:))
    [Wp{ii},FB{ii}]=scalar(p(ii),pts);
  end
  
  if length(p(:))==1
    Wp=Wp{1}; FB=FB{1};
  end
  
   
   
   
function [Wp,FB]=scalar(p,pts)


  
  phat = fft(p);
  
  FB = wpt_FB(pts,phat.d);


  for ii=1:size(phat.sig,2)
    Wp(:,ii) = ifft(select(phat,ii).*FB.ghatbank);
  end
     
     
%
%
%
     
function FB = wpt_FB(pts,ss)

% wavelet packet filter bank

  pts = ss(2)*pts;
  
  for ii=1:size(pts,2)-1
    G(ii,1) = sampled_signal('sineon',ss,pts(:,ii),pts(:,ii+1));
  end
  
  FB.ghatbank=setfield(G,'xlabel',GetGlobal('FreqLabel'));
   
  FB.pts  = pts;
  FB.name = 'Packet';
   
