
function p = zeropad(p,resinc)

%
% symetrically zero pad a sampled signal so that 
% its length is the next highest power of 2 (*2^resinc)

% arg process

   if nargin<2, resinc=0; end
   
% matrix case

   for ii=1:length(p(:))
     p(ii)=scalar(p(ii),resinc);
   end
   

% scalar case

function p=scalar(p,resinc)

   [rows,cols] = size(p.sig);

   if resinc<0
     nlength=2^(-resinc);
   else
     nlength = 2^(resinc + nextpow2(rows));
   end

   nzeros = (nlength-rows)/2;

   left  =  floor(nzeros);
   right =   ceil(nzeros);

   p.sig  = [ zeros(left,cols);  p.sig;  zeros(right,cols) ];
   p.d(2) = p.d(2)+p.d(1)*nzeros;

