
function val=frameval(W)

% matrix case

   for ii=1:length(W(:))
     val{ii}=scalar(W(ii));
   end
   val = reshape(val,size(W));
   if length(val)==1, val=val{1}; end

% scalar case

function val=scalar(W)

   Wp = W.sampled_signal;
   
   if sigsize(Wp,3)>1
     for ii=1:sigsize(Wp,3)
       sig = getfield(select(Wp,ii),'sig');
       val(ii) = (norm(sig(:))./norm(select(W.p,ii))).^2;
     end
   else
     sig = getfield(Wp,'sig');
     val = (norm(sig(:))./norm(W.p)).^2;
   end

   

