
% function f = icwt(W)
%
% Inverse "Continuous" or Overcomplete Wavelet Transform
%
% <sampled_signal> = icwt(<wavelet>)
%
% See Also:
%   cwt, uibank, GetFB


function f = icwt(W)

  disp('Computing icwt...')

  FB=W.FB;
  
  G = computeG(W);   
  
  ss = sigsize(FB.ghatbank);
  G = G.*(G>0.01) + (G<=0.01);
  
  GG = join(G(ones(ss(2),1)));
    
  FB.ghatbank = FB.ghatbank./GG;

  nsigs = sigsize(W.sampled_signal,3);
  
  for ii=1:nsigs
    
    disp(sprintf('...signal %d of %d',ii,nsigs))
    
    if nsigs==1
      Wsig=W.sampled_signal;
    else
      Wsig=select(W.sampled_signal,ii);
    end
    
    Wsighat = fft(Wsig);
    
    fhat(ii) = sum((Wsighat .* conj(FB.ghatbank)),2);
  
    f(ii,1) = ifft(fhat(ii));
    f(ii) = setfield(f(ii),'ylabel',[]);
  
    f(ii) = setfield(f(ii),'d0',getfield(W.sampled_signal,'d0'));
    
    f(ii) = name(f(ii),sprintf('icwt(%s)',name(W.sampled_signal)));
    
  end

  disp('...done computing icwt.')



