
function Wj = join(W)

% function Wj = join(W)
%
%    Combine wavelet array to single wavelet object
%    ...objects must have the same underlying filter bank


   if length(W)==1, Wj=W; return, end

   if ~FBequal(W)
     error('Can''t join CWTs with different filter banks!')
   end
   
   Wj=W(1);
   for ii=2:length(W)
     Wj.sampled_signal(ii)=W(ii).sampled_signal;
     Wj.p(ii)             =W(ii).p;
   end
   
   
%
%
%

function b=FBequal(W)

   b=1;
   
   FB = [W.FB];
   
   for ii=2:length(FB)
     
     b = b & all(sigsize(FB(1).ghatbank)==sigsize(FB(ii).ghatbank));

   end
    
   if b
     bsig = getfield(FB(1).ghatbank==FB(ii).ghatbank(:),'sig');
     b = b & all(bsig(:));
   end
