
function plot(W,opt)

% function plot(W,opt)
%
% graphically display a wavelet object
%
% opt:
%
%  'wt'   wavelet transform default
%
%  'ui'   plot with ui controls and menus
%
%  'menu' plot with only menus
%
%  'bank' show the magnitude Fourier transforms of the 
%         entire wavelet filter bank (WFB)
%	  
%  'G'    show the support function of the WFB


% arg process

  if nargin<2, opt='WT'; end
  
  % init
  
  W = join(W);
  
  SetUserData(gcf,'wavelet',W)
 
  if isa(opt,'double')
    which=opt;
    opt='WT';
  else
    which=1;
  end
  
  np = length(W.p);
  
  W.p = W.p(which);
  W.sampled_signal = W.sampled_signal(which);
  
  scalar(W,opt)

  index_menu(np)  % for ui indexing of multiple wavelet transforms
  
  
%
%
%
  
function scalar(W,opt)
  
% compute center freqs

  CFs=center_freqs(W);

% set d0 of sampled signal appropriately
  
  pcat = sigcat(join(W.p));
  W.sampled_signal = setfield(W.sampled_signal,'d0',getfield(pcat,'d0'));

  
% display 

  opt=lower(opt);

  if strcmp(opt,'ui')
    uicontrols(W)
    opt='wt';
  elseif strncmp(opt,'menu',4)
    menus
    opt='wt';
  end
  
  setplot set

  if strcmp(opt,'wt')
    
    setplot([4 1 1])
      plot(pcat)
%      set(gca,'vis','off')
      scale_axis(20,'y')
      xlabel('')
      h=get(gca,'title');
      set(h,'vis','on')
      hsig=gca;
      
    setplot([1.25 1 1.25 1])
    
      a0=CFs(2)/CFs(1);
      CC=CFs(1)/a0;
    
      him=imagesc(W,1:length(CFs));
      
      cytick=CFs(get(gca,'ytick'));
      
      ii=find(cytick>1);    
      cytick(ii)=round(cytick(ii));      
      cytick = round(100*cytick)/100;
    
      ytick = log(cytick/CC)/log(a0);      
     
      for ii=1:length(cytick), ylab{ii}=num2str(cytick(ii)); end
      set(gca,'ytick',ytick,'yticklabel',ylab)     
      
      grid	
      
      set(hsig,'xlim',get(gca,'xlim')) % set sig x-axis the same as wav
      
      set(him,'ButtonDownFcn','LineConstruct(0)','tag','wavelet')
      scale_axis(1) % reduce image bounds to avoid axis box removal
                  % when constructing lines
      colorbar(gca)
      
      label_plot(W.FB.name)

  elseif strcmp(opt,'g')
    
    setplot([1 1 1])
    plot(name(computeG(W),['G (' W.FB.name ')']))
    
  elseif strcmp(opt,'bank')
    
    setplot([1 1 1])
    plot(abs(name(W.FB.ghatbank,['Filter Bank (' W.FB.name ')'])))
    
  end
  
  SetUserData('W',W)
   
%
%
%

function uicontrols(W)
%
% uicontrols for wavelet plots

  clf

  [hGframe,hGui] = FramePanel;

  SetControlPos([0.02 0.02 0.15 0.05])
  [hframe,hui] = FramePanel;
  h=NewControl('pushbutton','v',[...
	'HideControls,'...
	'plot(GetUserData(''W'')),'...
	'hd=NewControl(''pushbutton'',''^'');'...
	'set(hd,''position'',[0.01 0.01 0.04 0.04]),'...
	'set(hd,''callback'',''ShowControls,plot(GetUserData(''''W''''))''),'...
	'set(hd,''tag'',''delete''),'...
	'h=NewControl(''pushbutton'',''Pr'');'...
	'set(h,''position'',[0.01 0.06 0.04 0.04]),'...
	'set(h,''callback'',''print_cwt''),'...
	'set(h,''tag'',''delete''),'...
	'clear h hd'...
	]);
 
  FramePanel(hframe,hui);
      
  [hframe,hui] = FramePanel;

     h1=NewControl('pushbutton','Mask','MaskProc');
     MoveRelPos(h1,hui,'up',2.5)
	
     hw = NewControl(...
	 'popupmenu',...
	 'width',...
	 '',...
	 4,...
	 [1:10 15:5:30] ...
	 );
     MoveRelPos(hw,h1,'up',1.2)
	
     FramePanel(hframe,hui);
     
     [hframe,hui] = FramePanel;
     
     h1=NewControl('pushbutton','Invert','icwtProc');
     MoveRelPos(h1,hui,'up',1.5)
     
     ha=NewControl('pushbutton','Apply','ApplyThreshProc');
     MoveRelPos(ha,h1,'up',1.5)
     
     ht = NewControl(...
	 'popupmenu',...
	 'Threshold',...
	 '',...
	 1,...
	 [0:10:90] ...
	 );
     MoveRelPos(ht,ha,'up',1)
	
     FramePanel(hframe,hui);
     
     [hframe,hui] = FramePanel;
     h=NewControl('text',getword(W.FB.name,1,'_'));
     
     MoveRelPos(h,hui,'up',1.2)
     FramePanel(hframe,hui);
     
  FramePanel(hGframe,findobj('style','frame'),0.02);   
  
   uiDisp('Wavelet','close')
   uiDisp('Ready')

   menus

%
%
%

function menus

   ColorMenu = uimenu('Label','ColorMap');
   
   uimenu(ColorMenu,'Label','Default','Callback',...
       'colormap(jet)','Accelerator', 'D');
   uimenu(ColorMenu,'Label','HSV','Callback',...
       'colormap(hsv)','Accelerator', 'S');
   uimenu(ColorMenu,'Label','Jet','Callback',...
       'colormap(jet)','Accelerator', 'J');
   uimenu(ColorMenu,'Label','Gray','Callback',...
       'colormap(''gray'')','Accelerator', 'G');
   uimenu(ColorMenu,'Label','Hot','Callback',...
       'colormap(''hot'')','Accelerator', 'H');
   uimenu(ColorMenu,'Label','Cool','Callback',...
       'colormap(''cool'')','Accelerator', 'C');
   uimenu(ColorMenu,'Label','Copper','Callback',...
       'colormap(''copper'')','Accelerator', 'O');
   uimenu(ColorMenu,'Label','Pink','Callback',...
       'colormap(''pink'')','Accelerator', 'P');
   uimenu(ColorMenu,'Label','Invert','Callback',...
       'colormap(1-colormap)','Accelerator', 'I');
   
   uimenu(ColorMenu,'Label','Zero','Callback',...
       'ThreshMap','Accelerator', 'Z');
      

   power = [ 0.5 2 4 ];
   PowerMenu = uimenu('Label','Power');
   for ii=1:length(power)
     h = uimenu(PowerMenu);
     
     eval(sprintf('set(h, ''Label'',''%3.1f'')',power(ii) ))
     
     eval(sprintf(...
	 'set(h, ''Callback'',''colormap(colormap.^%f)'')',...
	 power(ii)))
     eval(sprintf(...
	 'set(h, ''Accelerator'',''%d'')',...
	 floor(power(ii)) ))
   end

 
    

function index_menu(np)

   delete(findobj(gcf,'Label','Index','type','uimenu'))

   if np==1, return, end

   IndexMenu = uimenu('Label','Index');
   
   for ii=1:np
     uimenu(IndexMenu,'Label',num2str(ii),'Callback',...
	 sprintf('plot(GetUserData(gcf,''wavelet''),%d)',ii));
   end
   





function hout=colorbar(haxes)

% function hax=colorbar(haxes)
% 
% draws a color bar to the right of the
% axes using the current colormap

% arg process

   if nargin<1, haxes=gca; end

% make the colorbar data

   cmap = colormap;
   [rows,cols]= size(cmap);
   
   data = 1:rows;
   data = data/rows;
   
% make and position the axes
   
   hax=axes('ytick',[],'xtick',[]);
   
   MoveRelPos(hax,haxes,'right',0.99)
   MovePos(hax,'split',8)
   
% draw it
   
   colormap(cmap);
   him=imagesc(data');
   set(hax,'ydir','normal','xticklabel',[],'yticklabel',[]);

% label it

   ylim=get(gca,'ylim');
   xlim=get(gca,'xlim');
	
   h=text(mean(xlim),mean(ylim),1,'Color Map');
   set(h,'rotation',90,'HorizontalAlignment','center')
   set(h,'Color',cmap(1,:),'FontSize',9)

% restore to original axes

   axes(haxes)
   
   set([h,hax],'tag','delete')

% output

   if nargout>0, hout = hax; end

