
function W = wavelet(FB,Wp,p)

% function W = wavelet(in1,in2,in3)
%
% Constructor for wavelet class
%
% wavelet()
% wavelet(W)
% wavelet(FB)
% wavelet(FB,Wp)
% wavelet(FB,Wp,p)

  
% arg process

  if nargin<1
    FB=struct(...
	'ghatbank',    sampled_signal,...
	'scales',      []...
	);
  end

  
  if nargin<2, Wp=sampled_signal;   end
  if nargin<3, p =sampled_signal;   end

  W.FB = FB;
  W.p  = p;
  
% assign class and parents
  
  W=class(W,'wavelet',Wp); % the wavelet transform

% assign plot attributes

  W.FB.ghatbank = setfield(W.FB.ghatbank,'name',...
      'Filter Bank','xlabel',GetGlobal('FreqLabel'));
  
  
  W.sampled_signal = setfield(W.sampled_signal,...
      'xlabel',GetGlobal('TimeLabel'), ...
      'ylabel',GetGlobal('FreqLabel'), ...
      'name'  ,[ 'cwt(' getfield(p,'name') ')'] ...
  );

  
  
