import java.applet.*;
import java.awt.*;
import java.awt.event.*;
public class ExceptionHandling extends Applet implements ActionListener {
	private TextField first = new TextField(20);
	private TextField second = new TextField(20);
	private Button ok = new Button("  OK  ");
	private TextField answer = new TextField(20);
	private Label error = new Label(" ");
	private double top, bottom; // the two numbers to be divided
	public ExceptionHandling( )   {
		setFont(new Font("Serif", Font.PLAIN, 20));
		setLayout(new FlowLayout(FlowLayout.LEFT));
		add(first);
		add (new Label("First value      "));
		add(second);
		add (new Label("Second value   "));
		add (answer);
		answer.setEnabled(false);	// answer is read only
		add (new Label("First / Second  "));
		add(ok);
		ok.addActionListener(this);
		add(error);
		}
	public void actionPerformed(ActionEvent evt) throws NumberFormatException	{
		error.setText("");	//clear any error message
		error.setSize(400,20);
		try {
			top = Double.valueOf(first.getText( )).doubleValue();
		}
		catch(NumberFormatException e) {
			error.setText("Number format exception in first number");
			answer.setText("");//clear the answer fields
			return;
			}
		try {
	// the doubleValue method converts a String to a Double
	// the valueOf method converts a Double to a double
			bottom = Double.valueOf(second.getText( )).doubleValue();
		}
		catch(NumberFormatException e) {
			error.setText("Number format exception in second number");
			answer.setText("");//clear the answer fields
			return;
		}
		try {
			answer.setText(String.valueOf(top / bottom));
			if (bottom == 0.0) {
//				answer.setText("");
				throw new DivideByZeroException( );
			} 
		}
		catch(DivideByZeroException e) {
			error.setText("Division by zero");
		}
		catch(ArithmeticException e) {
			error.setText("Arithmetic exception occurred in calculation");
			}
		catch(Exception e) {
			error.setText("Unspecified exception occurred in calculation");
			}
		}
	}
