public class NewAccount {
	public static void main (String args[]) {
		Account sam = new Account("Sam Taylor",
								  "37 Church Lane, St. Neots, Cornwall, TR26 4RD",
								  "1448-985-881",
								  187.87);
		sam.displayDetails();
		if (sam.inCredit()) System.out.println("In credit");
		else System.out.println("Overdrawn");
		sam.setName("Samuel Taylor");		// change name
		System.out.println("Confirmation of new name : " + sam.getName());
		sam.setAddress("17 High Street, Derby, DE5 6TY");	// change the address
		sam.setBalance(-2387.67);			// change the balance
		sam.displayDetails();				//display all details again
		sam.creditReport();
	}
}

class Account {
	private String name;
	private String address;
	private String accountNumber;
	private double balance;

Account(String nam, String add, String acc, double bal) {
		name = nam;
		address = add;
		accountNumber = acc;
		balance = bal;
	}
	public void creditReport( ) {
		String m;
		displayDetails();
		if (inCredit()) m = "in credit";
		else if (getBalance() > -100) m = "overdrawn - send notification";
		else if (getBalance() > -1000) m = "overdrawn - send warning letter";
		else m = "Overdrawn - send suspend account notification";
		System.out.println("Account " + m);
	}
	public void displayDetails() {
		System.out.println("Name : " + name);
		System.out.println("Address : " + address);
		System.out.println("Account number : " + accountNumber);
		System.out.println("Account balance : " + balance);
	}
	public void setName(String customerName) {
		name = customerName;
	}
	public void setAddress(String customerAddress) {
		address = customerAddress;
	}
	public void setAccountNumber(String customerNumber) {
		accountNumber = customerNumber;
	}
	public void setBalance(double customerBalance) {
		balance = customerBalance;
	}
	public String getName( ) {
		return(name);
	}
	public String getAddress( ) {
		return(address);
	}
	public String getAccountNumber( ) {
		return(accountNumber);
	}
	public double getBalance( ) {
		return(balance);
	}
	public void credit(double amount) {
		balance = balance + amount;
	}
	public void debit(double amount) {
		balance = balance - amount;
	}
	public boolean inCredit() {
		if (balance < 0.00)return false; else return true;
	}
}
