public abstract class PCPart {
	String id;		//product identifier
	double cost;	//cost of product

	public void displayDetails() {
		System.out.print("Id number is  " + id);
		System.out.println("  Cost is : " + cost);
		}
	public double discount(int percentageDiscount) {
		double theDiscount;
		theDiscount = cost * percentageDiscount/100.0;
		return theDiscount;
	}
	public static void main(String args[ ]) {
		int reduction = 12;			//percentage reduction
		MBoardAndProc mbp = new MBoardAndProc("LXP45",
							  150.00,
							  MBoard.BX,
							  100,
							  MBoardAndProc.PENTIUM,
							  450);
		mbp.displayDetails( );
		System.out.println(reduction + "% discount is " + mbp.discount(reduction));
		Memory m = new Memory("QWERTY",100.0,Memory.EDO,256);
		m.displayDetails( );
		}
	}
class Memory extends PCPart{
	int type;			//type of memory either SDRAM, EDO or FASTPAGE
	int size;			//memory size in Mb
	static final int SDRAM = 0;	//SDRAM,EDO and FASTPAGE are types of memory
	static final int EDO = 1;
	static final int FASTPAGE = 2;
	public Memory(String ident, double price, int memType, int memSize){
		id = ident;
		cost = price;
		type = memType;
		size = memSize;
		}
	public void displayDetails() {
		super.displayDetails();
		String text = "Memory type : ";
		if (type == SDRAM) text += "168 pin SDRAM";
		else if (type == EDO) text += "72 pin EDO";
		else if (type == FASTPAGE) text += "72 pin fast page";
		System.out.println(text + " " + size + "Mb");
	}
}
class MBoard extends PCPart {
	int chipset;		//chipset either LX, BX or TX
	int busSpeed;		//speed of the motherboard bus
	static final int LX = 0;	//LX, BX and TX are chipsets
	static final int BX = 1;
	static final int TX = 2;
	public MBoard(String identifier, double price, int chips, int speed){
		id=identifier;
		cost=price;
		chipset = chips;
		busSpeed = speed;
		}
	public MBoard( ) {
	}
	public void displayDetails() {
		super.displayDetails();
		String text = "Motherboard chipset used : ";
		if (chipset == BX) text += "BX";
		else if (chipset == LX) text += "LX";
		else if (chipset == TX) text += "TX";
		System.out.println(text + "  Bus speed : " + busSpeed);
		}
	}
class MBoardAndProc extends MBoard {
	int procType;		//processor type either PENTIUM, AMDK6 or CYRIX
	int procSpeed;		//processor speed
	static final int PENTIUM = 0;	//three are types of processor
	static final int AMDK6 = 1;
	static final int CYRIX = 2;
	public MBoardAndProc(String identifier,
						double price,
						int chips,
						int speed,
						int type,
						int proSpeed){
		id=identifier;
		cost=price;
		chipset = chips;
		busSpeed = speed;
		procType = type;
		procSpeed = proSpeed;
		}
	public void displayDetails() {
		super.displayDetails();
		String text = "Processor type : ";
		if (procType == PENTIUM)text += "Pentium II";
		else if (procType == AMDK6)text += "AMD K6";
		else if (procType == CYRIX)text += "Cyrix mark III";
		System.out.println(text + " speed : " + procSpeed);
		}
}
