import java.awt.*;
import java.io.*;
import java.awt.event.*;
//The file Names.txt contains four pieces of date for every person:
//(string)name, (string)address, (int)age, (boolean)sex.
//The information is read sequentially until the end of the file is reached.
public class ReadFromFile extends Frame implements ActionListener {
	private TextField name = new TextField(20);
	private TextField address = new TextField(20);
	private TextField age = new TextField(20);
	private	CheckboxGroup g = new CheckboxGroup();
	private Checkbox male = new Checkbox("Male",g,true);
	private Checkbox female = new Checkbox("Female",g,false);
	private Button read = new Button("Read from file");
	private Button exit = new Button("Press to exit");
	DataInputStream in;
	public ReadFromFile() {
		Panel p = new Panel();
		try {
			in = new DataInputStream(new FileInputStream("Names.txt"));
		}
		catch(IOException e) {
			System.exit(0);
		}
		setLayout(new GridLayout(5,2));
		setFont(new Font("Serif", Font.PLAIN, 20));
//display all the components
		add(new Label("Name"));
		add(name);
		add(new Label("Address"));
		add(address);
		add(new Label("Age"));
		add(age);
		add(new Label("Sex"));
//add the Checkboxes to the panel and then add the Panel to the Frame
		p.setLayout(new GridLayout(1,2));
		p.add(male);
		p.add(female);
		p.setBackground(Color.yellow);
		add(p);
//add the "read" button to the Frame
		add(read);
//listen to the "read" button clicks
		read.addActionListener(this);
//add the "exit" button to the Frame
		add(exit);
//listen to the "exit" button clicks
		exit.addActionListener(this);
//specify the frame size and make it visible
		setTitle("Reading from file");
		setBackground(Color.yellow);
		setSize(400,200);
		setVisible(true);
//prevent the user from changing the displayed information
		name.setEditable(false);
		address.setEditable(false);
		age.setEditable(false);
		male.setEnabled(false);
		female.setEnabled(false);
	}
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == read) {	//if the read button clicked
			try {
				name.setText(in.readUTF());
				address.setText(in.readUTF());
//convert the int to String
				age.setText(String.valueOf(in.readInt()));
//if the boolean read is true set the "male" checkbox else set the "female"
				if (in.readBoolean()) male.setState(true); 
				else female.setState(true);
			}
			catch (IOException ex) {
				System.exit(0);
			} 
		} else if (e.getSource() == exit) System.exit(0); //exit button clicked
	}
	public static void main(String args[]) {
			new ReadFromFile();
		}
}
