import java.awt.*;
import java.io.*;
import java.awt.event.*;
//This application writes four items to a file:
//(String)name, (String)address, (int)age), (boolean)sex
public class SaveToFile extends Frame implements ActionListener {
	private TextField name = new TextField(20);
	private TextField address = new TextField(20);
	private TextField age = new TextField(20);
    private CheckboxGroup g = new CheckboxGroup();
	private Checkbox male = new Checkbox("Male",g,true);
	private Checkbox female = new Checkbox("Female",g,false);
	private Button write = new Button("Add to file");
	private Button exit = new Button("Press to exit");
	DataOutputStream out;
	public SaveToFile() {
		Panel p = new Panel();
		try {
			out = new DataOutputStream(new FileOutputStream("Names.txt"));
		}
		catch(IOException e) {
			System.exit(0);
		}
		setLayout(new GridLayout(5,2));
		setFont(new Font("Serif", Font.PLAIN, 20));
//display all the components
		add(new Label("Name"));
		add(name);
		add(new Label("Address"));
		add(address);
		add(new Label("Age"));
		add(age);
		add(new Label("Sex"));
//add the Checkboxes to the panel and then add the Panel to the Frame
		p.setLayout(new GridLayout(1,2));
		p.add(male);
		p.add(female);
		add(p);
		p.setBackground(Color.yellow);
//add the "write" button to the Frame
		add(write);
//listen to the "write" button clicks
		write.addActionListener(this);
//add the "exit" button to the Frame
		add(exit);
//listen to the "exit" button clicks
		exit.addActionListener(this);
//specify the frame size and make it visible
		setBackground(Color.yellow);
		setTitle("Saving to file");
		setSize(400,200);
		setVisible(true);
	}
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == write) {	//if the write button clicked
			try {
				out.writeUTF(name.getText( ));
				out.writeUTF(address.getText( ));
//convert the string to Integer and then to int
				out.writeInt(Integer.valueOf(age.getText()).intValue());
//if the "male" radio button is set write 'true' else write 'false'
				if (male.getState()) out.writeBoolean(true);
				else out.writeBoolean(false);
//clear the textfields ready for the next input
				name.setText("");
				address.setText("");
				age.setText("");
			}
			catch (IOException ex) {
				System.exit(0);
			} 
		} else if (e.getSource() == exit) System.exit(0); //exit button clicked
	}
	public static void main(String args[]) {
			new SaveToFile();
		}
}
