import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
public class SwingList extends JFrame implements ListSelectionListener {
	JPanel p;
	JList colorList;
	JTextField colorName;
	public SwingList( ) {
//set the JFrame title and size
		setTitle("Using Swing List");
		setSize(300,300);
//create a panel
		p = new JPanel( );
//create a list of the entries for the list
		String[ ] colors = {"red", "blue", "green", "orange", "yellow"};
//add the entries to the list and add the list to the panel
		colorList = new JList(colors);
		p.add(colorList);
//add a listener to pick up changes in the item selected in the list
		colorList.addListSelectionListener(this);
//instantiate a textfield, change the font and make the text alignment central
		colorName = new JTextField(15);
		colorName.setFont(new Font("Serif", Font.PLAIN, 20));
		colorName.setHorizontalAlignment(
				(int)TextField.CENTER_ALIGNMENT);
		p.add(colorName);
//the panel becomes the content pane
		setContentPane(p);
//display the frame containing the panel
	              setVisible(true);
//handle the clicking of the close icon on the frame
             		ClosingWindow close = new ClosingWindow( );
               	addWindowListener(close);
	}
	public void valueChanged(ListSelectionEvent e) {
//come here when a new list item is selected
//display the color in the textfield
		colorName.setText((colorList.getSelectedValue( )).toString( ));
		switch (colorList.getSelectedIndex( ))  {
			case 0 : p.setBackground(Color.red);
				break;
			case 1 : p.setBackground(Color.blue);
				break;
			case 2 : p.setBackground(Color.green);
				break;
			case 3 : p.setBackground(Color.orange);
				break;
			case 4 : p.setBackground(Color.yellow);
		}
	}
	public class ClosingWindow extends WindowAdapter {
              	public void windowClosing(WindowEvent e) {
	                        System.exit(0);   // end the program
              	  }
	} // end of the ClosingWindows inner class
	public static void main(String args[]){
              	new SwingList( );
	}
}