import java.awt.*;
import java.awt.event.*;
class UsingDialogs extends Frame implements ActionListener {
	private TextField text1 = new TextField(25);
	private TextField text2 = new TextField(25);
	private TextField text3 = new TextField(25);
	private TextField answer = new TextField(20);
	private Button okButton = new Button("   OK   ");
	private Button dialogButton = new Button("   OK   ");
	private	Dialog d = new Dialog(this, "Division by Zero",true);
	public UsingDialogs(String title) {
	// setup the frame
		setTitle(title);	
		setSize(250,200);
		setFont(new Font("Serif",Font.PLAIN,15));
		setLayout(new FlowLayout(FlowLayout.CENTER));
                setBackground(Color.yellow);  
		add(text1);
		add(text2);
		add(text3);
		add(okButton);
		okButton.addActionListener(this);
		setVisible(true);
	// setup the error dialog
		d.setSize(200,150);
		d.setLayout(new FlowLayout(FlowLayout.CENTER));
		d.add(new Label(" cannot divide by zero"));
		d.add(dialogButton);
		dialogButton.addActionListener(this);
		Close c = new Close();
		addWindowListener(c);
		d.addWindowListener(c);
	}
	public class Close extends WindowAdapter {
	// if the close icon on the dialog is clicked close the dialog
	// if the close icon on the main frame is clicked close the application
		public void windowClosing(WindowEvent e) {
			if (e.getSource() == d) d.dispose(); else  //close the dialog
			System.exit(0);		//end the application
		}
	} //end of the Close class
	public void actionPerformed(ActionEvent e) {
	// if the button on the dialog has been clicked close the dialog
		double value1, value2;
		if (e.getSource() == dialogButton) {
				text2.setText("");
				d.setVisible(false);
		}
	// if the OK button on the main window has been clicked, convert the
	// Strings in text2 and text3 to double, check for division by zero
	// and either display the error dialog or the result
			else if (e.getSource() == okButton)	{
	// the doubleValue method converts a String to a Double
	// the valueOf method converts a Double to a double
			value1 = Double.valueOf(text1.getText()).doubleValue();
			value2 = Double.valueOf(text2.getText()).doubleValue();
			if (value2 == 0) {		// division by zero
				text3.setText("");	//clear text3
				d.setVisible(true);	//display the dialog
			} else text3.setText(String.valueOf(value1/value2));	//display the answer
		}
	}
	public static void main(String args[]) {
		UsingDialogs f = new UsingDialogs("Dividing doubles");
	}
}