import java.applet.*;
import java.awt.*;
import java.awt.event.*;
public class UsingSelection extends Applet implements ActionListener {
	private TextArea myText = new TextArea(5,40);
	private Button cut = new Button(" CUT ");
	private Button paste = new Button("PASTE");
	private String clipBoard;
	public UsingSelection() 	{
		setFont(new Font("Serif",Font.PLAIN,18));
		add(myText);
		add(cut);
		cut.addActionListener(this);
		add(paste);
		paste.addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
		String newString;		//the text after cutting or pasting
		int cursorPosition;
		String s = myText.getText();	//the text in the TextArea component
		if (e.getSource() == cut) {
	//cut the selected text
	//put selected text into the clipBroad
			clipBoard = myText.getSelectedText();
	//get the text before the selected text
			newString = s.substring(0,myText.getSelectionStart());
	//add the text after the selected text
			newString += s.substring(myText.getSelectionEnd(), s.length());
	//save the cursor position at the start of the selected text
			cursorPosition = myText.getSelectionStart();
	//the new text is the same as the old with the selected part removed
			myText.setText(newString);
	//set the new cursor position
			myText.setCaretPosition(cursorPosition);
		}
		if (e.getSource() == paste) {
	//paste the text
	//get the text before the caret into newString
			newString = s.substring(0,myText.getCaretPosition());
	//add the text in the clipBoard
			newString += clipBoard;
	//add the text after the caret
			newString += s.substring(myText.getCaretPosition(),s.length());
	//the new cursor position is just after the pasted text
			cursorPosition = myText.getCaretPosition() + clipBoard.length();
	//the new text is the old text with the clipBoard text inserted
			myText.setText(newString);
	//set the new cursor position
			myText.setCaretPosition(cursorPosition);
		}
	}
}
