(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22334,        764]*)
(*NotebookOutlinePosition[     23348,        798]*)
(*  CellTagsIndexPosition[     23304,        794]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 1", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Solution of ODEs and Their Properties",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"1.3  Functions DSolve, NDSolve, and DifferentialInvariants", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"t", " ", 
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          \(x[t] + x[t]\^2 + t\^2\)}], ",", \(x[t]\), ",", "t"}], "]"}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(x[t]\/t + 3\ t\^3\)}], ",", \(x[\(-1\)] == 2\)}], "}"}], ",", 
        \(x[t]\), ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox[
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(-Sin[x[t]]\)}], ",", \(x[0] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
          "}"}], ",", \(x[t]\), ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox["<<Calculus`DSolveIntegrals`",
  FontSize->12]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["\<\
DifferentialInvariants[{x'[t]==-x[t](x[t]+y[t]),y'[t]==y[t](x[t]+y[\
t])},{x,y},t]\
\>", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"1.5  Applications of the Programs Sysn, Phase2D, PolarPhase and Phase3D", 
  "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-x\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \nvar = t; \n
    data = {{0, 0.5, 0.5}, {1, 0.5, 0.5}, {2, 0.5, 0.5}}; \nT1 = 15; \n
    index = {1, \ 2}; \nsteps = 500; \n\n
    Sysn[sys, {x, y}, var, data, T1, index, steps]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", 
          \(2\ Sin[\(2\ y\)\/\(t + 1\)]\ Exp[\(-\(t\/3\)\)]\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", 
          \(2\ Cos[\(2\ x\)\/\(t + 1\)]\ Exp[\(-\(t\/3\)\)]\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \nunk = {x, y}; \n
    data = {{0, 1, 1}, {1, 1, 1}, {2, 1, 1}, {3, 1, 1}}; \nT1 = 7; \n
    index = {1, \ 2}; \nsteps = 3500; \n\n
    Sysn[sys, unk, t, data, T1, index, steps]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-x\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {0, 0}, {0.2, 0}, {4, 0}, {0, 10}, 
      2000, {{\(-1.1\), 1.1}, {\(-1.1\), 1.1}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", 
          \(\(-x\) + \((0.5 - x\^2)\)\ y\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.4}, {3, 0}, {\(-3.5\), 10}, 
        1000, {{\(-3\), 3}, {\(-2.5\), 2.5}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "==", \(r\ \((1 - r)\)\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-1\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", \(unk = {r, \[CurlyPhi]}\), ";", "\n", 
      "\n", \(PolarPhase[sys, 
        unk, {0, 0}, {0.5, \[Pi]\/2}, {5, 4}, {\(-0.51\), 4}, 
        1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.13", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) - z\)}]}], ";", "\n", 
      RowBox[{
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "==", \(x + 0.2\ y\)}]}], ";"}]}], 
    RowBox[{
      RowBox[{"eq3", "=", 
        RowBox[{
          SuperscriptBox["z", "\[Prime]",
            MultilineFunction->None], "==", \(0.2 + z\ \((x - 2.2)\)\)}]}], 
      ";", "\n", \(sys = {eq1, eq2, eq3}\), ";", "\n", "\n", 
      \(Phase3D[
        sys, {x, y, z}, {2, 2, 0}, {0, 0, 0}, {0, 0, 0}, {0, 60}, {0, 60}, 
        20000, All]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) - z\)}]}], ";", "\n", 
      RowBox[{
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "==", \(x + 0.2\ y\)}]}], ";"}]}], 
    RowBox[{
      RowBox[{"eq3", "=", 
        RowBox[{
          SuperscriptBox["z", "\[Prime]",
            MultilineFunction->None], "==", \(0.2 + z\ \((x - 2.2)\)\)}]}], 
      ";", "\n", \(sys = {eq1, eq2, eq3}\), ";", "\n", "\n", 
      \(Phase3D[
        sys, {x, y, z}, {2, 2, 0}, {0, 0, 0}, {0, 0, 0}, {0, 60}, {50, 60}, 
        20000, All]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.14", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-6\)\ x - y - 3\ x\^2\)}]}], 
      ";"}], \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {\(-1\), 0}, {0.5, 1.8}, {3, 1}, {\(-2\), 2}, 
      10000, {{\(-3.1\), 1.5}, {\(-3\), 2.5}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {\(-1\), 0}, {0.5, 1.8}, {3, 1}, {\(-1\), 1.3}, 
      10000, {{\(-3.1\), 1.5}, {\(-3\), 2.5}}, 1]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.15", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-10\)\ x + x\^3\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {0, 0}, {2, 2.5}, {2, 2}, {\(-1\), 1}, 
      10000, {{\(-6\), 6}, {\(-10\), 10}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.16", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(y\ \((1 + y)\)\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", 
          \(\(-\(x\/2\)\) + y\/5 - x\ y + \(6\ y\^2\)\/5\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {\(-1\), 0}, {0.6, 0.5}, {6, 1}, {\(-35\), 5}, 
      10000, {{\(-6\), 5}, {\(-3\), 3}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.17", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", 
          \(3\ x\^4 - 12\ x\^2\ y\^2 + y\^4\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(6\ x\^3\ y - 10\ x\ y\^3\)}]}], 
      ";"}], \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {0, 0}, {2, 2}, {3, 3}, {\(-0.2\), 0.2}, 
      10000, {{\(-4.5\), 4.5}, {\(-4.5\), 4.5}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.18", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(Sin[x\ y]\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(Cos[x\ y]\)}]}], ";"}], 
  \(sys = {eq1, eq2}; \n\n
    Phase2D[sys, {x, y}, {\[Pi]\/2, \[Pi]\/2}, {0.4, 0.4}, {4, 4}, {\(-10\), 
        20}, 1000, {{0, \[Pi]}, {0, \[Pi]}}, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.6 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Yin-yang", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", 
          \(y + x\ \((1 - x\^2 - y\^2)\)\)}]}], ";"}], 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", 
          \(\(-x\) + y\ \((1 - x\^2 - y\^2)\)\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {0, 0}, {0.4, 0.4}, {5, 5}, {0, 5}, 
        1000, {{\(-2\), 2}, {\(-2\), 2}}, 2]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(y \((x\^2 - y\^2)\)\)}]}], ";", 
      "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\)\ \((x\^2 - y\^2)\)\)}]}],
       ";", "\n", \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {0, 0}, {0.4, 0.4}, {5, 5}, {\(-10\), 10}, 
        1000, {{\(-3\), 3}, {\(-3\), 3}}, 2]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Prey-predator model", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(x - x\ y\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) + x\ y\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {1, 1}, {0.5, 0.5}, {2, 2}, {1, 10}, 
        1000, {{0, 2.8}, {0, 2.8}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Exercise ",
  StyleBox["4. Competing species model ",
    FontSize->14]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"eq1", "=", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "==", \(x - x\ y - 0.5  x\^2\)}]}], 
        ";", "\n", 
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "==", 
            \(\(-y\) + x\ y - 0.5  y\^2\)}]}], ";", "\n", 
        \(sys = {eq1, eq2}\), ";", "\n", "\n", 
        \(Phase2D[sys, {x, y}, {6/5, 2/5}, {0.5, 0.1}, {2, 4}, {0, 10}, 
          1000, {{0, 3}, {0, 1.5}}, 0]\)}], "\n"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Pendulum", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-Sin[x]\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {0, 0}, {2.5, 0.5}, {7, 6}, {\(-10\), 10}, 
        1000, {{\(-16\), 16}, {\(-7\), 7}}, 0]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Pendulum with linear friction", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-Sin[x]\) - 0.1  y\)}]}], ";",
       "\n", \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(Phase2D[sys, {x, y}, {0, 0}, {3.5, 1}, {4, 4}, {\(-10\), 10}, 
        1000, {{\(-15\), 15}, {\(-10\), 10}}, 0]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "==", \(r\ \((1 - r\^2)\)\)}]}], ";", 
      "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-1\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(PolarPhase[
        sys, {r, \[CurlyPhi]}, {0, 0}, {0.5, \[Pi]\/2}, {3, 3}, {0, 5}, 
        1000, {{\(-1.5\), 1.5}, {\(-1.5\), 1.5}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "==", 
          \(r\ \((1 - r)\) \((2 - r)\)\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-2\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", 
      \(PolarPhase[
        sys, {r, \[CurlyPhi]}, {0, 0}, {0.2, \[Pi]\/2}, {12, 3}, {\(-25\), 
          0}, 3000, {{\(-3\), 3}, {\(-3\), 3}}, 2]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{765, 446},
WindowMargins->{{Automatic, 1}, {Automatic, -4}},
PrintingCopies->1,
PrintingPageRange->{1, 1},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 259, 10, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2195, 73, 62, 1, 91, "Section"],
Cell[2260, 76, 536, 16, 60, "Text"],
Cell[2799, 94, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2945, 102, 175, 3, 91, "Section"],

Cell[CellGroupData[{
Cell[3145, 109, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3262, 114, 398, 12, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3697, 131, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3814, 136, 432, 12, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4283, 153, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4400, 158, 686, 18, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5123, 181, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5240, 186, 155, 4, 34, "Input"],
Cell[5398, 192, 182, 6, 34, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5629, 204, 191, 4, 124, "Section"],

Cell[CellGroupData[{
Cell[5845, 212, 114, 3, 57, "Subsection"],
Cell[5962, 217, 627, 17, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6626, 239, 114, 3, 57, "Subsection"],
Cell[6743, 244, 741, 19, 277, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7521, 268, 115, 3, 57, "Subsection"],
Cell[7639, 273, 565, 16, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8241, 294, 115, 3, 57, "Subsection"],
Cell[8359, 299, 627, 16, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9023, 320, 115, 3, 57, "Subsection"],
Cell[9141, 325, 675, 17, 162, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9853, 347, 115, 3, 57, "Subsection"],
Cell[9971, 352, 814, 22, 140, "Input"],
Cell[10788, 376, 815, 22, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11640, 403, 115, 3, 57, "Subsection"],
Cell[11758, 408, 600, 16, 120, "Input"],
Cell[12361, 426, 227, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12625, 436, 115, 3, 57, "Subsection"],
Cell[12743, 441, 579, 16, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13359, 462, 115, 3, 57, "Subsection"],
Cell[13477, 467, 638, 17, 152, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14152, 489, 115, 3, 57, "Subsection"],
Cell[14270, 494, 641, 17, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14948, 516, 115, 3, 57, "Subsection"],
Cell[15066, 521, 596, 16, 141, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15711, 543, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[15864, 549, 123, 3, 57, "Subsection"],
Cell[15990, 554, 671, 18, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16698, 577, 114, 3, 57, "Subsection"],
Cell[16815, 582, 635, 16, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17487, 603, 134, 3, 57, "Subsection"],
Cell[17624, 608, 593, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18254, 628, 189, 7, 36, "Subsection"],
Cell[18446, 637, 686, 18, 141, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19169, 660, 123, 3, 57, "Subsection"],
Cell[19295, 665, 592, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19924, 685, 144, 3, 57, "Subsection"],
Cell[20071, 690, 605, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20713, 710, 114, 3, 57, "Subsection"],
Cell[20830, 715, 648, 17, 141, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21515, 737, 114, 3, 57, "Subsection"],
Cell[21632, 742, 662, 17, 141, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

