(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13726,        464]*)
(*NotebookOutlinePosition[     14659,        495]*)
(*  CellTagsIndexPosition[     14615,        491]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 10", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox["Rigid Body with a Fixed Point",
  FontSlant->"Italic"]], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.6 The Program Poinsot", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 10.1 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 0.5; \nB = 1; \nC0 = 1.5; \nr0 = 3; \n\[Theta]0 = \[Pi]/4; \nT = 3; 
    \n\[Alpha] = \[Pi]/2; \nsteps = 1000; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], steps]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.2 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nr0 = 3; \n\[Theta]0 = \[Pi]/4; \nT = 3; \n
    \[Alpha] = \[Pi]/2; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.3 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 0.5; \nB = 1; \nC0 = 1.5; \nr0 = 3; \n\[Theta]0 = 0.05; \nT = 4; \n
    \[Alpha] = \[Pi]/20; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.4 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 0.5; \nB = 1.5; \nC0 = 1; \nr0 = 1; \n\[Theta]0 = \(-0.1\); \n
    T = 30; \n\[Alpha] = \[Pi]; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.7 The Program Solid", "Section",
  FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Example 10.5",
  FontFamily->"Times New Roman"]], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 1.1; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, 0, \(-1\)}; \np0 = 0; \nq0 = 0; \nr0 = 3; \n
    \[Psi]0 = 0; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \nT = 10; \n
    steps = 1000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, 1000]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 1.1; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, 0, \(-1\)}; \np0 = 0; \nq0 = 0; \nr0 = 10; \n
    \[Psi]0 = 0; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \nT = 20; \n
    steps = 5000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, 1000]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A = 1; \nB = 0.9; \nC0 = 1.1; \n
    va = {\[Psi], \[CurlyPhi], \[Theta], t}; \nz = {0, 0, 1}; \n
    F = {0, 0, \(-1\)}; \np0 = 0; \nq0 = 0; \nr0 = 3; \n\[Psi]0 = 0; \n
    \[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \nT = 20; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, 1000]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A = 1; \nB = 0.8; \nC0 = 1.2; \n
    va = {\[Psi], \[CurlyPhi], \[Theta], t}; \nz = {0, 0, 1}; \n
    F = {0, 0, \(-1\)}; \np0 = 0; \nq0 = 0; \nr0 = 8; \n\[Psi]0 = 0; \n
    \[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \nT = 20; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, 1000]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A = 1; \nB = 0.8; \nC0 = 1.2; \n
    va = {\[Psi], \[CurlyPhi], \[Theta], t}; \nz = {0, 0, 1}; \n
    F = {0, 0, \(-1\) - Cos[\[Theta][t]]}; \np0 = 0; \nq0 = 0; \nr0 = 6; \n
    \[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \n
    T = 10; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, 1000]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["10.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 2; \nr0 = 2; \n\[Theta]0 = \[Pi]/5; \nT = 5; \n
    \[Alpha] = \[Pi]/2; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 3; \nC0 = 5; \nr0 = 2; \n\[Theta]0 = \(-\[Pi]\)/20; \n
    T = 5; \n\[Alpha] = \[Pi]/10; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 5; \nB = 3; \nC0 = 1; \nr0 = 2; \n\[Theta]0 = \(-\[Pi]\)/20; \n
    T = 5; \n\[Alpha] = \[Pi]/15; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 5; \nB = 1; \nC0 = 3; \nr0 = 2; \n\[Theta]0 = \(-\[Pi]\)/20; \n
    T = 5; \n\[Alpha] = \[Pi]; \n
    Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 1000]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, 0, \(-1\)}; \np0 = 1; \nq0 = 0; \nr0 = 10; \n
    \[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \n
    T = 10; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Exercise 6.",
  StyleBox[" ",
    FontWeight->"Plain"]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, 0, \(-1\)}; \np0 = 0; \nq0 = 0; \nr0 = 6; \n
    \[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \n
    T = 10; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, 0, \(-1\)}; \np0 = 1; \nq0 = 0; \nr0 = 20; \n
    \[Psi]0 = 0; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \nT = 20; \n
    steps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, Sin[\[CurlyPhi][t]], \(-1\)}; \np0 = 0; \n
    q0 = 0.2; \nr0 = 4; \n\[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n
    \[Theta]0 = \[Pi]/4; \nT = 10; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 0.5; \nB = 1; \nC0 = 1.5; \n
    va = {\[Psi], \[CurlyPhi], \[Theta], t}; \nz = {0, 0, 1}; \n
    F = {0, 0, \(-1\)}; \np0 = 1; \nq0 = 0; \nr0 = 5; \n
    \[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \n
    T = 40; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 1; \nB = 1; \nC0 = 0.5; \nva = {\[Psi], \[CurlyPhi], \[Theta], t}; 
    \nz = {0, 0, 1}; \nF = {0, Sin[\[CurlyPhi][t]], \(-1\)}; \np0 = 0; \n
    q0 = 0.2; \nr0 = 8; \n\[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n
    \[Theta]0 = \[Pi]/4; \nT = 20; \nsteps = 3000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = 0.8; \nB = 1; \nC0 = 1.2; \n
    va = {\[Psi], \[CurlyPhi], \[Theta], t}; \nz = {0, 0, 1}; \n
    F = {0, Sin[\[CurlyPhi][t]], \ \(-1\)}; \np0 = 0; \nq0 = 0.2; \nr0 = 8; \n
    \[Psi]0 = \(-\[Pi]\)/2; \n\[CurlyPhi]0 = 0; \n\[Theta]0 = \[Pi]/4; \n
    T = 20; \nsteps = 5000; \n
    Solid[A, \ B, \ C0, va, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \ 
      \[Theta]0, \ T, steps]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{753, 382},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 133, 4, 116, "Title",
  Evaluatable->False],
Cell[1912, 59, 236, 7, 63, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2173, 70, 62, 1, 91, "Section"],
Cell[2238, 73, 536, 16, 60, "Text"],
Cell[2777, 91, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2923, 99, 141, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3089, 105, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3208, 110, 271, 6, 203, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3516, 121, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3635, 126, 252, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3924, 137, 116, 3, 57, "Subsection"],
Cell[4043, 142, 252, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4332, 153, 116, 3, 57, "Subsection"],
Cell[4451, 158, 254, 6, 182, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4754, 170, 106, 1, 65, "Section"],

Cell[CellGroupData[{
Cell[4885, 175, 135, 3, 57, "Subsection"],
Cell[5023, 180, 423, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5483, 193, 82, 2, 57, "Subsection"],
Cell[5568, 197, 424, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6029, 210, 82, 2, 57, "Subsection"],
Cell[6114, 214, 425, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6576, 227, 82, 2, 57, "Subsection"],
Cell[6661, 231, 425, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7123, 244, 82, 2, 57, "Subsection"],
Cell[7208, 248, 460, 9, 329, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7717, 263, 96, 1, 65, "Section"],

Cell[CellGroupData[{
Cell[7838, 268, 114, 3, 57, "Subsection"],
Cell[7955, 273, 250, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8242, 284, 115, 3, 57, "Subsection"],
Cell[8360, 289, 257, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8654, 300, 114, 3, 57, "Subsection"],
Cell[8771, 305, 257, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9065, 316, 114, 3, 57, "Subsection"],
Cell[9182, 321, 254, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9473, 332, 114, 3, 57, "Subsection"],
Cell[9590, 337, 436, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10063, 350, 172, 7, 57, "Subsection"],
Cell[10238, 359, 435, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10710, 372, 114, 3, 57, "Subsection"],
Cell[10827, 377, 425, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11289, 390, 114, 3, 57, "Subsection"],
Cell[11406, 395, 455, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11898, 408, 114, 3, 57, "Subsection"],
Cell[12015, 413, 442, 9, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12494, 427, 115, 3, 57, "Subsection"],
Cell[12612, 432, 455, 8, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13104, 445, 115, 3, 57, "Subsection"],
Cell[13222, 450, 464, 9, 329, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

