(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23606,        840]*)
(*NotebookOutlinePosition[     24533,        871]*)
(*  CellTagsIndexPosition[     24489,        867]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 3", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Power Series Solution of ODEs \nand Frobenius Series",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.2  Power Series and the Program Taylor", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Examples relative to the built-in functions Series and Normal\
\>", 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Series[Sin[x], {x, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Normal[Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example relative to the program Taylor", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Taylor[Sin[x\ y], {x, y}, {0, 0}, 7]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.5 The Program SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Example 3.3: Material point subjected to an undamped and aging \
spring\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    StyleBox[
      RowBox[{
        RowBox[{"sys", "=", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "==", "y"}], ",", " ", 
              RowBox[{
                SuperscriptBox[
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "\[Prime]",
                  MultilineFunction->None], "==", 
                \(\(-Exp[\(-0.1\)\ t]\)\ x\)}]}], "}"}]}], ";", "\n", 
        \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}],
      FontSize->12]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 3.4:  Material point subjected to its weight and a \
resistence\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "u"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "w"}], ",", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-0.0001\) \(\@\(u\^2 + w\^2\)\) u\)}], ",", 
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-10\) - 0.0001 \(\@\( u\^2 + w\^2\)\) w\)}]}], "}"}]}], ";",
       "\n", \(unk = {x, y, u, w}\), ";", "\n", 
      \(unk0 = {0, 0, 100\ Cos[45\ Degree], 100\ Sin[45\ Degree]}\), ";", 
      "\n", "\n", \(SerSol[sys, unk, t, unk0, 4, 0, 14, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.6 Other Applications of SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.5: Airy's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-t\)\ x\)}]}], "}"}]}], 
      ";", "\n", "\n", \(SerSol[sys, {x, y}, t, {1, 1}, 6, 0, 2, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.6: Mathieu's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-\((1 - Cos[t])\)\)\ x\)}]}], "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]\[Prime]",
              MultilineFunction->None], "==", \(t\^2 + x\^2\)}], "}"}]}], ";",
       "\n", "\n", \(SerSol[sys, {x}, t, {0}, 11, 0, 1.9, 2000]\)}]], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.8: Hermite's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(2\ t\ y - 6  x\)}]}], 
          "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, \(-12\)}, 4, 0, 4, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.7 The Program Frobenius", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(x\ \)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(x\ y\)}], " ", "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 3, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\ \)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \((1 + x)\) y' - \((1 + x\^3)\) y\  == 
          0\), ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", 
      StyleBox[
        \(Frobenius[eq, unk, var, 
          5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\),
        FontSize->12]}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      StyleBox[
        \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \((5 + x\^2)\) y' + 
              \((4 + x\^2)\) y\  == 0\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(unk = y\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(var = x\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], "\n", "\n", 
      \(Frobenius[eq, unk, var, 
        5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"Frobenius", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(\(x\ \)\/2\), 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", 
            \(1\/4\ \((x - Sin[x])\)\ x\ y\)}], "==", "0"}], ",", "y", ",", 
        "x", ",", "7", ",", \({0.2, 5}\), ",", 
        RowBox[{"{", 
          RowBox[{\(y[0.2] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0.2", "]"}], "==", 
              "0.5"}]}], "}"}], ",", "1000"}], "]"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-4\)\ x + t\ Cos[t]\)}]}],
           "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 1.5, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(x - y + 2\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(y - \ x + t\)}]}], " ", 
          "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(y + Exp[t]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x + Sin[t]\)}]}], "}"}]}], 
      ";", "\n", "\n", \(SerSol[sys, {x, y}, t, {0, 1}, 5, 0, 2, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "z"}], ",", 
            RowBox[{
              SuperscriptBox["z", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-6\)\ x - 11\ y - 6\ z + Exp[\(-t\)]\)}]}], " ", "}"}]}], 
      ";", "\n", "\n", 
      \(SerSol[sys, {x, y, z}, t, {0, 1, 0}, 20, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(-Sin[y]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x\^2\)}]}], "}"}]}], ";", 
      "\n", "\n", \(SerSol[sys, {x, y}, t, {1, 0.5}, 4, 0, 1, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(\(x\^3\) y\)}], "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 6, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ y' + 3  x\^2\ y\  == 0; \nunk = y; \n
    var = x; \n\n
    Frobenius[eq, unk, var, 10, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 
      1000]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", \(\((1\/8 + x\^4)\)\ y\)}], 
          "==", "0"}]}], ";", "\n", 
      \(Frobenius[eq, y, x, 8, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \ y' + 2  x\ y\  == 0; \n\n
    Frobenius[eq, y, x, 6, {0.3, 3}, {y[0.3] == 0, \(y'\)[0.3] == 1}, 1000]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(x\ \)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(x\ \ y\)}], " ", "==", 
          "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 5, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", 
      \(Frobenius[eq, y, x, 3, {0.5, 5}, {y[0.5] == 1, \(y'\)[0.5] == 3}, 
        1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\ \(y'\)[x] + y[x] == 0, y[x], x]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\^2\ \(y'\)[x] + y[x] == 0, y[x], x]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(\((x\^2 + 1)\) y\)}], "==",
           "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[
      \(x\^2\) \(\(y'\)'\)[x] + x\ \ \(y'\)[x] + \((x\^2 + 1)\) y[x] == 0, 
      y[x], x]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", 
            \(\((x\^2 - 1)\) \((x\^2 + 4)\) y\)}], "==", "0"}]}], ";", "\n", 
      "\n", \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            FractionBox[
              RowBox[{"x", " ", 
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None]}], "2"], "+", 
            \(1\/4\ x\ Cos[x]\ y\)}], "==", "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{674, 498},
WindowMargins->{{25, Automatic}, {Automatic, -4}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 258, 9, 100, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2194, 72, 62, 1, 91, "Section"],
Cell[2259, 75, 536, 16, 60, "Text"],
Cell[2798, 93, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2944, 101, 156, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3125, 107, 175, 6, 47, "Subsection",
  Evaluatable->False],
Cell[3303, 115, 133, 4, 35, "Input"],
Cell[3439, 121, 147, 4, 35, "Input"],
Cell[3589, 127, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3781, 136, 141, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3925, 141, 144, 4, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4118, 151, 138, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[4281, 157, 182, 6, 69, "Subsection",
  Evaluatable->False],
Cell[4466, 165, 707, 19, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5210, 189, 182, 6, 57, "Subsection"],
Cell[5395, 197, 1000, 24, 133, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6444, 227, 148, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[6617, 233, 131, 3, 57, "Subsection"],
Cell[6751, 238, 530, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7318, 258, 134, 3, 57, "Subsection"],
Cell[7455, 263, 557, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8049, 283, 114, 3, 57, "Subsection"],
Cell[8166, 288, 381, 11, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8584, 304, 135, 3, 57, "Subsection"],
Cell[8722, 309, 549, 15, 77, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9320, 330, 141, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[9486, 336, 114, 3, 57, "Subsection"],
Cell[9603, 341, 601, 15, 119, "Input"],
Cell[10207, 358, 35, 1, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10279, 364, 115, 3, 57, "Subsection"],
Cell[10397, 369, 421, 11, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10855, 385, 116, 3, 57, "Subsection"],
Cell[10974, 390, 694, 24, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11705, 419, 115, 3, 57, "Subsection"],
Cell[11823, 424, 937, 24, 85, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12809, 454, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[12962, 460, 114, 3, 57, "Subsection"],
Cell[13079, 465, 552, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13668, 485, 114, 3, 57, "Subsection"],
Cell[13785, 490, 555, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14377, 510, 114, 3, 57, "Subsection"],
Cell[14494, 515, 542, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15073, 535, 114, 3, 57, "Subsection"],
Cell[15190, 540, 718, 19, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15945, 564, 114, 3, 57, "Subsection"],
Cell[16062, 569, 535, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16634, 589, 114, 3, 57, "Subsection"],
Cell[16751, 594, 469, 12, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17257, 611, 114, 3, 57, "Subsection"],
Cell[17374, 616, 286, 7, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17697, 628, 114, 3, 57, "Subsection"],
Cell[17814, 633, 508, 14, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18359, 652, 114, 3, 57, "Subsection"],
Cell[18476, 657, 251, 6, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18764, 668, 115, 3, 57, "Subsection"],
Cell[18882, 673, 426, 12, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19345, 690, 115, 3, 57, "Subsection"],
Cell[19463, 695, 575, 16, 77, "Input"],
Cell[20041, 713, 178, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20256, 723, 115, 3, 57, "Subsection"],
Cell[20374, 728, 529, 14, 77, "Input"],
Cell[20906, 744, 185, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21128, 754, 115, 3, 57, "Subsection"],
Cell[21246, 759, 553, 15, 77, "Input"],
Cell[21802, 776, 206, 6, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22045, 787, 115, 3, 57, "Subsection"],
Cell[22163, 792, 570, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22770, 812, 115, 3, 57, "Subsection"],
Cell[22888, 817, 678, 18, 104, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

