(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10946,        419]*)
(*NotebookOutlinePosition[     11879,        450]*)
(*  CellTagsIndexPosition[     11835,        446]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 5", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Problems of Stability",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.5 The Program Liapunov", "Section",
  FontFamily->"Times New Roman"]], "Section",
  TextAlignment->Left,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y + x\ y\^4 - 2  x\^3, y' == 2\ x + 2\ x\^2\ y\^3 - y\^7}; 
    \n\nLiapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 
      50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.4 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ y\), y' == \(-x\) - 2\ y - y\^3}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 0.6, 
      0.75, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + \ y, y' == \(-x\) - y - x\^3}; \n\n
    Liapunov[sys, {x, y}, x\^2 + x\ y + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 
      1.4, 1, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.6 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ x\), y' == \(-y\) + y\^2}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 0.5, 
      0.75, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-y\) - x\ \((x\^2 + y\^2)\), 
        y' == x - y\ \((x\^2 + y\^2)\)}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 50]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.7 The Program LStability", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == 2\ x\ y, y' == 1 - 3\ x\^2 - y\^2}; \n
    xe = {{0, \(-1\)}, {0, 1}, {\(-1\)/\@3, 0}, {1/\@3, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.9 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y}; \n
    xe = {{0, 0}, {1/2, 1/2}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == x + y, y' == 2\ x\ y}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) + y == 0, \(-x\) + 2\ x\ y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y}; \n
    xe = {{1/2, 1/2}, {0, 0}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) - y}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{x - y == 0, \(-x\) - y - x\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == x - y, y' == \(-x\) - y - x\^3}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{y == 0, \(-x\) + \((1\/2 - x\^2)\) y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \((1\/2 - x\^2)\) y}; \nxe = {{0, 0}}; \n
    \nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-2\)\ x - y - x\ \((x\^2 + y\^2)\), 
        y' == x - y + y\ \((x\^2 + y\^2)\)}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\((1 + x)\) Sin[x - 3\ y] == 0, 1 - x - Cos[y] == 0}, {x, y}]\)],
   "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \((1 + x)\) Sin[x - 3\ y], y' == 1 - x - Cos[y]}; \n
    xe = {{0, 0}, {\(-1\), \(-ArcCos[2]\)}, {\(-1\), ArcCos[2]}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \((1 + y)\) - Exp[\(-x\)], y' == y - Sin[x]}; \n
    xe = {{0, 0}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) == 0, \(-y\) + y\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \(-x\), y' == \(-y\) + y\^3}; \n
    xe = {{0, 0}, {0, \(-1\)}, {0, 1}}; \n\nLStability[sys, {x, y}, xe]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\)}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{719, 362},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 243, 10, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2179, 73, 62, 1, 91, "Section"],
Cell[2244, 76, 536, 16, 60, "Text"],
Cell[2783, 94, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2929, 102, 163, 3, 91, "Section"],

Cell[CellGroupData[{
Cell[3117, 109, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3235, 114, 269, 6, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3541, 125, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3660, 130, 254, 6, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3951, 141, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4070, 146, 259, 6, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4366, 157, 116, 3, 57, "Subsection"],
Cell[4485, 162, 247, 6, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4769, 173, 115, 3, 57, "Subsection"],
Cell[4887, 178, 283, 7, 78, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5219, 191, 142, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[5386, 197, 115, 3, 57, "Subsection"],
Cell[5504, 202, 257, 6, 116, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5798, 213, 116, 3, 57, "Subsection"],
Cell[5917, 218, 223, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6177, 228, 116, 3, 57, "Subsection"],
Cell[6296, 233, 197, 5, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6542, 244, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[6695, 250, 115, 3, 57, "Subsection"],
Cell[6813, 255, 163, 4, 35, "Input"],
Cell[6979, 261, 223, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7239, 271, 114, 3, 57, "Subsection"],
Cell[7356, 276, 205, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7598, 286, 114, 3, 57, "Subsection"],
Cell[7715, 291, 159, 4, 35, "Input"],
Cell[7877, 297, 207, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8121, 307, 114, 3, 57, "Subsection"],
Cell[8238, 312, 166, 4, 57, "Input"],
Cell[8407, 318, 214, 5, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8658, 328, 114, 3, 57, "Subsection"],
Cell[8775, 333, 258, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9070, 344, 114, 3, 57, "Subsection"],
Cell[9187, 349, 179, 5, 35, "Input"],
Cell[9369, 356, 276, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9682, 367, 114, 3, 57, "Subsection"],
Cell[9799, 372, 220, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10056, 382, 114, 3, 57, "Subsection"],
Cell[10173, 387, 156, 4, 35, "Input"],
Cell[10332, 393, 228, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10597, 404, 114, 3, 57, "Subsection"],
Cell[10714, 409, 192, 5, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

