(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18150,        710]*)
(*NotebookOutlinePosition[     19084,        741]*)
(*  CellTagsIndexPosition[     19040,        737]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 7", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Bifurcation in ODEs",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.3 The Programs Bif1 and Bif1G", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = u' == \[Alpha] + u; \nunk = u; \npar = \[Alpha]; \n\n
    Bif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\(\nBif1G[eq, unk, par, 1, 1, 20]\)\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = u' == \[Alpha] - u\^2; \nunk = u; \npar = \[Alpha]; \n\n
    Bif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = 
      x' == \((\[Lambda]\ x - x\^3)\) \((\((\[Lambda] + 2)\) + x\^2 + 1)\); \n
    unk = x; \npar = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \((\[Lambda] + x - x\^3)\) \((\[Lambda]\^2 + x\^2 - 1)\); \n
    unk = x; \npar = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.4 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = u' == \[Alpha] + u\^2; \nunk = u; \npar = \[Alpha]; \n\n
    Bif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = u' == \[Alpha] + \[Alpha]\ u\^2 + u\^3; \nunk = u; \n
    par = \[Alpha]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] - \(x\^2\) \((1 + x\^2)\)\^2; \nunk = x; \n
    par = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + x\^4; \nunk = x; \npar = \[Lambda]; \n\n
    Bif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Mu]\ \ x\^2 + x\^4; \nunk = x; \npar = \[Mu]; \n\n
    Bif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] - x\^2\/\(1 + x\^2\); \nunk = x; \n
    par = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] - x\^2\/\((1 + x\^2)\)\^2; \nunk = x; \n
    par = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] - x\/\(1 + x\^2\); \nunk = x; \npar = \[Lambda]; \n
    \nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \((\[Lambda] - x\^2)\)\ \((3\ \[Lambda] - x + 1)\); \n
    unk = x; \npar = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \((\[Lambda] - x)\)\ \((\[Lambda] - x\^2)\); \nunk = x; \n
    par = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \((\(-\[Lambda]\) - x)\)\ \((\[Lambda] - x\^2)\); \nunk = x; 
    \npar = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \((\[Lambda] - x)\)\ \((\[Lambda] - 2\ x\^2)\); \nunk = x; \n
    par = \[Lambda]; \n\nBif1[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 0.5, 50]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.6 The Programs Bif2 and Bif2G", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + \[Mu]\ x + x\^2; \nunk = x; \n
    par = {\[Lambda], \[Mu]}; \nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + \[Mu]\ x - x\^3; \nunk = x; \n
    par = {\[Lambda], \[Mu]}; \nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\ \)], "Input"],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.7 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + \[Mu]\ x\^2 - x\^3 + \[Lambda]\ x\^4; \nunk = x; 
    \npar = {\[Lambda], \[Mu]}; \nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + \((\[Mu] - \[Lambda])\)\ x + x\^2; \nunk = x; \n
    par = {\[Lambda], \[Mu]}; \nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda]\^2 + 2\ \[Mu]\ \[Lambda]\ x + \[Mu] + x\^2; \n
    unk = x; \npar = {\[Lambda], \[Mu]}; \n\nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.01]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(eq = 
        x' == \[Lambda]\^2 + 2\ \[Mu]\ \[Lambda]\ x + \[Mu] + 
            x\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(par = {\[Mu], \[Lambda]};\)\n\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = x' == \[Lambda] + \[Mu] + \[Lambda]\^2\ x + \[Mu]\ x\^2 - x\^3; \n
    unk = x; \npar = {\[Lambda], \[Mu]}; \n\nBif2[eq, unk, par]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.01]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.9 The Program HopfBif", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \[Epsilon]\ x - 3\ y + x\ \((x\^2 + y\^2)\)\^3, 
        y' == 3\ x - \[Epsilon]\ y + y\ \((x\^2 + y\^2)\)\^3}; \n
    unk = {x, y}; \n\n
    HopfBif[sys, unk, \[Epsilon], {\(-1\), 1}, {0.4, 6}, {0, 0}, {0, 4}, 300]
      \)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == x + y, 
        y' == \((\[Epsilon] - 2)\) x + \((\[Epsilon] - 1)\) y - x\^3 - 
            \(x\^2\) y}; \nunk = {x, y}; \n\n
    HopfBif[sys, unk, \[Epsilon], {\(-1\), 1}, {0.4, 6}, {0, 0}, {0, 4}, 300]
      \)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \[Lambda]\ x + y - x \((x\^2 + y\^2)\), 
        y' == \(-x\) + \[Lambda]\ y - y \((x\^2 + y\^2)\)}; \nunk = {x, y}; \n
    \nHopfBif[sys, unk, 
      \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 500]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.10 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(sys = {x' == y, y' == \(-x\) + \[Lambda]\ y - y\^3}; \nunk = {x, y}; 
    \npar = \[Lambda]; \nvalpar = {\(-0.5\), 0.5}; \n
    HopfBif[sys, unk, par, valpar, {0.2, 10}, {0, 0}, {0, 6}, 500]\ \)\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \[Lambda]\ x + \((\[Lambda] - 2)\) y, 
        y' == \(-\((\[Lambda] - 2)\)\) x + \[Lambda]\ \ y - y\ x\^2 + y\^3}; 
    \nunk = {x, y}; \n\n
    HopfBif[sys, unk, \[Lambda], {\(-0.2\), 0.2}, {0.02, 10}, {0, 0}, {0, 2}, 
      500]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {
        x' == 2\ \[Lambda]\ x + \((\[Lambda] - 1)\) y - x \((x\^2 + y\^2)\), 
        y' == \(-\((\[Lambda] + 1)\)\) x + 2\ \[Lambda]\ y - 
            y \((x\^2 + y\^2)\)}; \nunk = {x, y}; \n\n
    HopfBif[sys, unk, \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 
      500]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Lambda]\ y - y \((x\^2 + y\^2)\)}; \n
    unk = {x, y}; \n\n
    HopfBif[sys, unk, \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 
      500]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(sys
       = {x' == \[Lambda]\ x + y + \((x\ y + x\ y\^2)\)\^2, 
        y' == \(-x\) + \[Lambda]\ y - \((x\^2 + y\^2)\)}; \nunk = {x, y}; \n\n
    HopfBif[sys, unk, 
      \[Lambda], {\(-0.5\), 0.5}, {0.0005, 20}, {0, 0}, {0, 4}, 1500]\ \)\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{708, 398},
WindowMargins->{{14, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 225, 9, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2161, 72, 62, 1, 91, "Section"],
Cell[2226, 75, 536, 16, 60, "Text"],
Cell[2765, 93, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2911, 101, 147, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3083, 107, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3200, 112, 163, 4, 119, "Input"],
Cell[3366, 118, 117, 3, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3520, 126, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3637, 131, 166, 4, 120, "Input"],
Cell[3806, 137, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3954, 145, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4071, 150, 221, 5, 120, "Input"],
Cell[4295, 157, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4443, 165, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4560, 170, 208, 4, 120, "Input"],
Cell[4771, 176, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4931, 185, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[5084, 191, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5202, 196, 166, 4, 120, "Input"],
Cell[5371, 202, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5519, 210, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5637, 215, 183, 4, 120, "Input"],
Cell[5823, 221, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5971, 229, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6089, 234, 190, 4, 121, "Input"],
Cell[6282, 240, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6430, 248, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6548, 253, 168, 4, 120, "Input"],
Cell[6719, 259, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6867, 267, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6985, 272, 168, 4, 120, "Input"],
Cell[7156, 278, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7304, 286, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7422, 291, 182, 4, 150, "Input"],
Cell[7607, 297, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7755, 305, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7873, 310, 187, 4, 153, "Input"],
Cell[8063, 316, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8211, 324, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8329, 329, 179, 4, 142, "Input"],
Cell[8511, 335, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8659, 343, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8777, 348, 202, 4, 120, "Input"],
Cell[8982, 354, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9130, 362, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9249, 367, 195, 4, 120, "Input"],
Cell[9447, 373, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9595, 381, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9714, 386, 200, 4, 120, "Input"],
Cell[9917, 392, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10065, 400, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10184, 405, 198, 4, 120, "Input"],
Cell[10385, 411, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10547, 420, 147, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[10719, 426, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10837, 431, 186, 4, 99, "Input"],
Cell[11026, 437, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11180, 445, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11297, 450, 186, 4, 99, "Input"],
Cell[11486, 456, 35, 1, 35, "Input"],
Cell[11524, 459, 117, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11690, 468, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[11843, 474, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11961, 479, 207, 4, 99, "Input"],
Cell[12171, 485, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12325, 493, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12443, 498, 204, 4, 99, "Input"],
Cell[12650, 504, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12804, 512, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12922, 517, 213, 4, 120, "Input"],
Cell[13138, 523, 117, 3, 35, "Input"],
Cell[13258, 528, 286, 8, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13581, 541, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13699, 546, 217, 4, 120, "Input"],
Cell[13919, 552, 117, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14085, 561, 139, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[14249, 567, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[14366, 572, 317, 7, 104, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14720, 584, 114, 3, 57, "Subsection"],
Cell[14837, 589, 305, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15179, 601, 114, 3, 57, "Subsection"],
Cell[15296, 606, 307, 7, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15652, 619, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[15806, 625, 114, 3, 57, "Subsection"],
Cell[15923, 630, 281, 6, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16241, 641, 114, 3, 57, "Subsection"],
Cell[16358, 646, 326, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16721, 658, 114, 3, 57, "Subsection"],
Cell[16838, 663, 373, 8, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17248, 676, 114, 3, 57, "Subsection"],
Cell[17365, 681, 264, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17666, 692, 114, 3, 57, "Subsection"],
Cell[17783, 697, 327, 8, 103, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

