(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15658,        545]*)
(*NotebookOutlinePosition[     16592,        576]*)
(*  CellTagsIndexPosition[     16548,        572]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 8", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["The Lindstedt-Poincar\[EAcute] Method",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
" 8.3 The Programs LindPoic and GLindPoinc", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 8.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\^3};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 2;\)\n\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 
      0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon] \((x + y\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 1;\)\n\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 
      0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon]\ y \((9 - x\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 1;\)\n\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.08, {6}, {0, 30}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) + \[Epsilon]\ y \((9 - x\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 1;\)\n\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.08, {6}, {0, 30}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Mu]\ y \((1 - x + y)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Mu]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Mu] \((y - y\^3\/3)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Mu]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.6, {2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\ \ y\^2}; \nunk = {x, y}; 
    \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.5, 0.8}, {0, 20}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    StyleBox[\(<< Calculus`DSolveIntegrals`\),
      FontSize->12]], "Input",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(DifferentialInvariants[{\(x'\)[t] == y[t], 
        \(y'\)[t] == \(-x[t]\) - \[Epsilon]\ x[t]\ \ y[t]\^2}, {x[t], y[t]}, 
      t]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ \((x\^2 + y\^2 - 2)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {0.5, 1, 1.5}, {0, 20}]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    StyleBox[\(<< Calculus`DSolveIntegrals`\),
      FontSize->12]], "Input",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(DifferentialInvariants[{\(x'\)[t] == y[t], 
        \(y'\)[t] == \(-x[t]\) - \[Epsilon]\ \((x[t]\^2 + y[t]\^2 - 2)\)}, {
        x[t], y[t]}, t]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y - \[Mu]\ y\^2, 
        y' == \(-x\) + \[Mu]\ y\^2\/\(x\^2 + y\^2 - 1\)}; \nunk = {x, y}; \n
    var = t; \npar = \[Mu]; \nm = 1; \n\nLindPoinc[sys, unk, var, par, m]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {0.00006, 0.0002}, {0, 50}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(CriticalEqS[sys, unk, 6]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.13", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + 4  y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ y\ \((x\^2 + 4  y\^2 - 4)\)\)}]}], "}"}]}], 
      ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", \(m = 1\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, m]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {2\ \@\(2/5\)}, {0, 10}]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 8.4 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y + \[Mu] 
                  \((4\ x - 5\ x\^3 + x\^5 - 5\ x\ y\^2 + 2\ x\^3\ y\^2 + 
                      x\ y\^4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) + 
                \[Mu] \((
                    4\ y - 5\ x\^2\ y + x\^4\ y - 5\ y\^3 + 2\ x\^2\ y\^3 + 
                      y\^5)\)\)}]}], "}"}]}], ";", "\n", \(unk = {x, y}\), 
      ";", "\n", \(var = t\), ";", "\n", \(par = \[Mu]\), ";", "\n", 
      \(m = 1\), ";", "\n", "\n", \(LindPoinc[sys, unk, var, par, m]\)}]], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\(-1\), \(-2\)}, {0, 5}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ y\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", \(m = 1\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, m]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {\@3}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, \(-0.2\), {\@3}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ y\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ x\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.5, 1, 1.5}, {\(-3\), 3}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\) \((x\^2 + y\^2 - 2)\)\)}],
             ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - 
                \[Mu]\ y\ \((x\^2 + y\^2 - 4)\) \((x\^2 + y\^2 - 2)\)\)}]}], 
          "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", 
      "\n", \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\@2, 2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ 
                  \((x - \(2\ x\)\/\@\(x\^2 + y\^2\) + 
                      x\^2\/\(x\^2 + y\^2\) - \(x\ y\)\/\(x\^2 + y\^2\))
                    \)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - 
                \[Mu]\ \ 
                  \((y - \(2\ y\)\/\@\(x\^2 + y\^2\) + 
                      \(x\ y\)\/\(x\^2 + y\^2\) - y\^2\/\(x\^2 + y\^2\))
                    \)\)}]}], "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n",
       \(var = t\), ";", "\n", \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{730, 340},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->False,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 243, 9, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2179, 72, 62, 1, 91, "Section"],
Cell[2244, 75, 536, 16, 60, "Text"],
Cell[2783, 93, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2929, 101, 158, 3, 91, "Section"],

Cell[CellGroupData[{
Cell[3112, 108, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3229, 113, 316, 8, 162, "Input"],
Cell[3548, 123, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3740, 132, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3857, 137, 336, 9, 162, "Input"],
Cell[4196, 148, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4388, 157, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4505, 162, 339, 9, 162, "Input"],
Cell[4847, 173, 132, 3, 35, "Input"],
Cell[4982, 178, 339, 9, 162, "Input"],
Cell[5324, 189, 132, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5493, 197, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5610, 202, 237, 5, 161, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5884, 212, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6001, 217, 236, 5, 196, "Input"],
Cell[6240, 224, 131, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6408, 232, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6526, 237, 239, 5, 161, "Input"],
Cell[6768, 244, 146, 4, 35, "Input"],
Cell[6917, 250, 124, 3, 33, "Input"],
Cell[7044, 255, 212, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7293, 265, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7411, 270, 251, 5, 161, "Input"],
Cell[7665, 277, 144, 4, 35, "Input"],
Cell[7812, 283, 124, 3, 33, "Input"],
Cell[7939, 288, 226, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8202, 298, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8320, 303, 266, 6, 194, "Input"],
Cell[8589, 311, 148, 4, 35, "Input"],
Cell[8740, 317, 106, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8883, 325, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9001, 330, 708, 17, 161, "Input"],
Cell[9712, 349, 144, 4, 46, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9905, 359, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[10059, 365, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10177, 370, 883, 22, 183, "Input"],
Cell[11063, 394, 146, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11246, 403, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11363, 408, 702, 17, 161, "Input"],
Cell[12068, 427, 133, 3, 46, "Input"],
Cell[12204, 432, 138, 3, 46, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12379, 440, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12497, 445, 680, 17, 140, "Input"],
Cell[13180, 464, 148, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13365, 473, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13483, 478, 758, 19, 140, "Input"],
Cell[14244, 499, 136, 3, 46, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14417, 507, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[14535, 512, 948, 23, 278, "Input"],
Cell[15486, 537, 132, 3, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

