(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15052,        503]*)
(*NotebookOutlinePosition[     15985,        534]*)
(*  CellTagsIndexPosition[     15941,        530]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 9", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Boundary-Value Problems for Second-Order ODEs",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE5\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.3  The Program NBoundary", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' - x\ y' + y\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {1.5, 2}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(eq = \(y'\)' - x\ y' + y\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {1.9, 2.5}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2\ \[Pi]}; 
    \ndata = {y[0] == 0, y[2\ \[Pi]] == 0}; \n{dymin, dymax} = {\(-1\), 1}; \n
    n = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2\ \[Pi]}; 
    \ndata = {y[0] == 0, y[2\ \[Pi]] == 1}; \n{dymin, dymax} = {\(-1\), 1}; \n
    n = 10; \nsteps = 1000; \nansol = Sin[x]; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {\(-4\), \(-3.5\)}; \nn = 10; \nsteps = 1000; \n
    ansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {52, 53}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = 0.01 \( y'\)' + \((x - 0.5)\)\ y' == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == \(-1\)}; 
    \n{dymin, dymax} = {\(-1\), 1}; \nn = 10; \nsteps = 5000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\^2\ y' + Sin[x] - \(x\^2\) Cos[x] == 0; \nunk = y; \n
    var = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 0, y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2}; 
    \n{dymin, dymax} = {\(-1\), 1.5}; \nn = 10; \nsteps = 2000; \n
    ansol = Sin[x]; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"9.5  The Programs NBoundary1 and NBoundary2", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.14 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2  \[Pi]}; 
    \ndata = {y[0] == 0, y[2  \[Pi]] == 0}; \nn = 50; \nansol = Sin[x]; \n
    NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.15 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y' + Sin[x] - \(x\^2\) Cos[x] == 0; \nunk = y; 
    \nvar = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 0, y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2}; \nn = 200; \n
    ansol = Sin[x]; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.16 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y' - x + x\ Sin[x] + Cos[x] == 0; \nunk = y; \n
    var = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 1, y[2  \[Pi]] == 1 + 2  \[Pi]}; \nn = 300; \n
    ansol = x + Cos[x]; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.17 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = 0.01 \( y'\)' + \((x - 0.5)\) y' == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == \(-1\)}; \nn = 300; \n
    ansol = 0; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.18 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100\ x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; \nn = 50; \ns = 1; \n
    steps = 20; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.19 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y\^2 - Cos[x] + Sin[x] + x\ Sin[x]\^2 == 0; \n
    unk = y; \nvar = x; \n{a, b} = {0, \[Pi]/2}; \n
    data = {y[0] == 0, y[\[Pi]/2] == 1}; \nn = 65; \ns = 1; \nsteps = 20; \n
    ansol = Sin[x]; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.20 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 1}; \nn = 50; \ns = 1; \n
    steps = 50; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 1}; 
    \n{dymin, \ dymax} = {\(-1.12\), \(-1.1\)}; \nn = 50; \ns = 1; \n
    steps = 50; \nansol = 0; \n
    NBoundary[eq, \ unk, \ var, \ {a, \ b}, \ data, \ {dymin, \ dymax}, \ n, 
      \ steps, \ ansol]\ \)\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.21 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(y\^2\) y' + 2 \((Cos[x] + Sin[x])\) Sin[x]\^2 == 0; \n
    unk = y; \nvar = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 1, y[2  \[Pi]] == 1}; \nn = 80; \ns = 1; \nsteps = 20; \n
    ansol = Sin[x] + Cos[x]; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.6  Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + 10 == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 10}; \n
    data = {y[0] == 1, y[10] == 30}; \n{dymin, dymax} = {50, 60}; \nn = 10; \n
    steps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 1}; 
    \ndata = {y[0] == 1, y[1] == 2}; \n{dymin, dymax} = {0, 2}; \nn = 10; \n
    steps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) \((\ y')\)\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 0}; 
    \n{dymin, dymax} = {\(-2\), 1}; \nn = 10; \nsteps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + Sin[x]\ y == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, \[Pi]}; \n
    \(data = \(data = {y[0] - \(y'\)[0] == 0, y[\[Pi]] == 0.5}\); \); 
    \n{dymin, dymax} = {\(-1\), 0}; \nn = 10; \nsteps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y'\^2 - Sin[3  x] == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 0}; \nn = 40; \ns = 1; \n
    steps = 20; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y - Sin[3\ x] == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 2}; \ndata = {y[0] == 1, y[2] == 0}; \nn = 200; \n
    ansol = 0; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 1}; 
    \ndata = {y[0] == 1, y[1] == 0}; \nn = 100; \nansol = 0; \n
    NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{730, 461},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 267, 10, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2203, 73, 62, 1, 91, "Section"],
Cell[2268, 76, 536, 16, 60, "Text"],
Cell[2807, 94, 109, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2953, 102, 142, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3120, 108, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3237, 113, 348, 7, 225, "Input"],
Cell[3588, 122, 350, 7, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3975, 134, 114, 3, 57, "Subsection"],
Cell[4092, 139, 354, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4483, 151, 114, 3, 57, "Subsection"],
Cell[4600, 156, 359, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4996, 168, 115, 3, 57, "Subsection"],
Cell[5114, 173, 370, 8, 224, "Input"],
Cell[5487, 183, 355, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5879, 195, 115, 3, 57, "Subsection"],
Cell[5997, 200, 367, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6401, 212, 115, 3, 57, "Subsection"],
Cell[6519, 217, 427, 9, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6995, 232, 160, 3, 65, "Section"],

Cell[CellGroupData[{
Cell[7180, 239, 116, 3, 57, "Subsection"],
Cell[7299, 244, 282, 5, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7618, 254, 116, 3, 57, "Subsection"],
Cell[7737, 259, 349, 7, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8123, 271, 116, 3, 57, "Subsection"],
Cell[8242, 276, 334, 7, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8613, 288, 116, 3, 57, "Subsection"],
Cell[8732, 293, 291, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9060, 304, 116, 3, 57, "Subsection"],
Cell[9179, 309, 318, 6, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9534, 320, 116, 3, 57, "Subsection"],
Cell[9653, 325, 366, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10056, 337, 116, 3, 57, "Subsection"],
Cell[10175, 342, 319, 6, 224, "Input"],
Cell[10497, 350, 413, 8, 245, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10947, 363, 116, 3, 57, "Subsection"],
Cell[11066, 368, 379, 7, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11494, 381, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[11648, 387, 114, 3, 57, "Subsection"],
Cell[11765, 392, 341, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12143, 404, 114, 3, 57, "Subsection"],
Cell[12260, 409, 343, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12640, 421, 114, 3, 57, "Subsection"],
Cell[12757, 426, 361, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13155, 438, 115, 3, 57, "Subsection"],
Cell[13273, 443, 392, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13702, 456, 115, 3, 57, "Subsection"],
Cell[13820, 461, 325, 6, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14182, 472, 115, 3, 57, "Subsection"],
Cell[14300, 477, 286, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14623, 488, 115, 3, 57, "Subsection"],
Cell[14741, 493, 271, 5, 182, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

