(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15701,        378]*)
(*NotebookOutlinePosition[     16345,        400]*)
(*  CellTagsIndexPosition[     16301,        396]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\(LindPoinc[sys_, unk_, var_, par_, m_] := 
      Module[{n, data, xu, subst, sysfi, ap1, sol1, syst, z, yp, red, G}, 
        Off[Solve::svars]; 
        If[m > 2, 
          Print[StyleForm["\<The approximation order has to be 1 or 2.\>", \
"\<Output\>", FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12]]; 
          Goto[2]]; n = Length[sys]; \[IndentingNewLine]data = {X, 0}; 
        xu[h_] := SeriesData[par, 0, 
            Table[\(u1[h, k]\)[var], {k, 0, m}]]; \[IndentingNewLine]subst = 
          Flatten[Table[{unk[\([h]\)] \[Rule] 
                  xu[h], \(Derivative[1]\)[unk[\([h]\)]] \[Rule] 
                  D[xu[h], var]}, {h, 1, n}]]; 
        sysfi = sys /. subst; \[IndentingNewLine]apl[h_] := 
          LogicalExpand[sysfi[\([h]\)]]; \[IndentingNewLine]sol[0] = 
          Flatten[DSolve[
              Flatten[Table[{\(apl[h]\)[\([1]\)], \(u1[h, 0]\)[0] \[Equal] 
                      data[\([h]\)]}, {h, 1, n}]], 
              Table[\(u1[h, 0]\)[var], {h, 1, n}], 
              var]]; \[IndentingNewLine]syst[k_] := 
          TrigExpand[
            Flatten[{Table[\(apl[h]\)[\([k + 1]\)], {h, 1, n}] /. 
                  Flatten[Table[sol[j], {j, 0, k - 1}]], 
                Table[\(u1[h, k]\)[0] \[Equal] 0, {h, 1, 
                    n}]}]]; \[IndentingNewLine]sol[k_] := 
          Flatten[DSolve[syst[k], Table[\(u1[h, k]\)[var], {h, 1, n}], 
              var]]; \[IndentingNewLine]Do[sol[k], {k, 1, m}]; 
        Do[\(vf[h]\)[var] = 
            ComplexExpand[\(sol[0]\)[\([h, 2]\)] + 
                Sum[par^k*\(sol[k]\)[\([h, 2]\)], {k, 1, m}]], {h, 1, 
            n}]; \[IndentingNewLine]tau[s_] := 
          s/\((1 + Sum[w[k]*par^k, {k, 1, m}])\); \[IndentingNewLine]Do[\(z[
                h]\)[s] = \(vf[h]\)[var] /. var \[Rule] tau[s]; \(yp[h]\)[
              s] = Expand[Normal[Series[\(z[h]\)[s], {par, 0, m}]]], {h, 1, 
            n}]; \[IndentingNewLine]c1 = Coefficient[\(yp[1]\)[s], par]; 
        c2 = Coefficient[\(yp[2]\)[s], par]; \[IndentingNewLine]c1s = 
          Coefficient[c1, s]; 
        c2s = Coefficient[c2, s]; \[IndentingNewLine]s1 = 
          Simplify[
            DeleteCases[
              Solve[{c1s \[Equal] 0, c2s \[Equal] 0}, {X, w[1]}], {X \[Rule] 
                  0}]]; \[IndentingNewLine]If[Length[s1] \[Equal] 0, 
          Print[StyleForm["\<There is no periodic solution.\>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12]]; 
          Goto[3], Goto[0]]; 
        Label[0]; \[IndentingNewLine]Do[
          f1[j] = \((\(\(yp[1]\)[s] /. par \[Rule] 0\) /. s1[\([j]\)])\) + 
              Simplify[Coefficient[\(yp[1]\)[s] /. s1[\([j]\)], par], 
                  Trig \[Rule] True]*par; \[IndentingNewLine]g1[
              j] = \((\(\(yp[2]\)[s] /. par \[Rule] 0\) /. s1[\([j]\)])\) + 
              Simplify[Coefficient[\(yp[2]\)[s] /. s1[\([j]\)], par], 
                  Trig \[Rule] True]*par, {j, 1, Length[s1]}]; 
        If[m \[Equal] 1, Goto[2], Goto[1]]; 
        Label[1]; \[IndentingNewLine]Do[
          d1[j] = Coefficient[\(yp[1]\)[s], par^2] /. 
              s1[\([j]\)]; \[IndentingNewLine]d2[j] = 
            Coefficient[\(yp[2]\)[s], par^2] /. 
              s1[\([j]\)]; \[IndentingNewLine]d1s[j] = 
            Coefficient[d1[j], s] /. s1[\([j]\)]; \[IndentingNewLine]d2s[j] = 
            Coefficient[d2[j], s^2] /. s1[\([j]\)]; \[IndentingNewLine]s2[
              j] = Simplify[
              DeleteCases[
                Solve[{d1s[j] \[Equal] 0, d2s[j] \[Equal] 0}, {X, 
                    w[2]}], {X \[Rule] 0}]], {j, 1, 
            Length[s1]}]; \[IndentingNewLine]Do[
          f2[j, k] = \((\(\(yp[1]\)[s] /. par \[Rule] 0\) /. s1[\([j]\)])\) + 
              Simplify[
                  Coefficient[\(\(yp[1]\)[s] /. 
                        s1[\([j]\)]\) /. \(s2[j]\)[\([k]\)], par], 
                  Trig \[Rule] True]*par + 
              Simplify[
                  Coefficient[\(\(yp[1]\)[s] /. 
                        s1[\([j]\)]\) /. \(s2[j]\)[\([k]\)], par^2], 
                  Trig \[Rule] True]*par^2; 
          g2[j, k] = \((\(\(yp[2]\)[s] /. par \[Rule] 0\) /. s1[\([j]\)])\) + 
              Simplify[
                  Coefficient[\(\(yp[2]\)[s] /. 
                        s1[\([j]\)]\) /. \(s2[j]\)[\([k]\)], par], 
                  Trig \[Rule] True]*par + 
              Simplify[
                  Coefficient[\(\(yp[2]\)[s] /. 
                        s1[\([j]\)]\) /. \(s2[j]\)[\([k]\)], par^2], 
                  Trig \[Rule] True]*par^2, {j, 1, Length[s1]}, {k, 1, 
            Length[s2[j]]}]; \[IndentingNewLine]Do[
          Do[Print[
              StyleForm["\<The expansion of periodic motions to within terms \
of order \>", "\<Output\>", FontFamily \[Rule] "\<Times-Plain\>", 
                FontSize \[Rule] 12], 2, 
              StyleForm["\< are:\>", "\<Output\>", 
                FontFamily \[Rule] "\<Times-Plain\>", 
                FontSize \[Rule] 12]]; \[IndentingNewLine]Print[unk[\([1]\)], 
              StyleForm["\< = \>", "\<Output\>", 
                FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
              f2[j, k] /. {X \[Rule] Global`X, 
                  s \[Rule] Global`s}]; \[IndentingNewLine]Print[
              unk[\([2]\)], 
              StyleForm["\< = \>", "\<Output\>", 
                FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
              g2[j, k] /. {X \[Rule] Global`X, 
                  s \[Rule] Global`s}]; \[IndentingNewLine]Print[
              StyleForm["\<where\>", "\<Output\>", 
                FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12]]; 
            Print["\<\>"]; 
            ta2[j, k] = 
              t*\((\(1 + Sum[w[k]*par^k, {k, 1, m}] /. 
                      s1[\([j]\)]\) /. \(s2[j]\)[\([k]\)])\); 
            Print[StyleForm["\<s = \>", "\<Output\>", 
                FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
              ta2[j, k] /. {t \[Rule] Global`t, X \[Rule] Global`X, 
                  s \[Rule] Global`s}], {k, 1, Length[s2[j]]}], {j, 1, 
            Length[s1]}]; Goto[3]; 
        Label[2]; \[IndentingNewLine]Do[
          Print[StyleForm["\<The expansion of periodic motions to within \
terms of order \>", "\<Output\>", FontFamily \[Rule] "\<Times-Plain\>", 
              FontSize \[Rule] 12], 2, 
            StyleForm["\< are:\>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", 
              FontSize \[Rule] 12]]; \[IndentingNewLine]Print[unk[\([1]\)], 
            StyleForm["\< = \>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
            f1[j] /. {X \[Rule] Global`X, s \[Rule] Global`s}]; 
          Print[unk[\([2]\)], 
            StyleForm["\< = \>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
            g1[j] /. {X \[Rule] Global`X, s \[Rule] Global`s}]; 
          Print[StyleForm["\<where\>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12]]; 
          Print["\<\>"]; \[IndentingNewLine]ta1[j] = 
            t*\((1 + Sum[w[k]*par^k, {k, 1, m}])\) /. 
              s1[\([j]\)]; \[IndentingNewLine]Print[
            StyleForm["\<s = \>", "\<Output\>", 
              FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12], 
            ta1[j] /. {t \[Rule] Global`t, X \[Rule] Global`X, 
                s \[Rule] Global`s}], {j, 1, Length[s1]}]; Label[3]; 
        Print["\< \>"]; \[IndentingNewLine]Print[
          StyleForm["\<Use GLindPoinc to compare graphically the numerical \
solution with the approximate one for a given value of the parameter in the \
time interval (T1,T2).\>", "\<Output\>", 
            FontFamily \[Rule] "\<Times-Plain\>", 
            FontSize \[Rule] 12]]; \[IndentingNewLine]Print[
          StyleForm["\<We suggest choosing the initial value list of x0 with \
the same length of periodic orbits.\>", "\<Output\>", 
            FontFamily \[Rule] "\<Times-Plain\>", 
            FontSize \[Rule] 12]]; \[IndentingNewLine]Print[
          StyleForm["\<When any orbit is periodic, the length of x0 is \
arbitrary.\>", "\<Output\>", FontFamily \[Rule] "\<Times-Plain\>", 
            FontSize \[Rule] 12]]; Goto[2]; 
        Label[3]; \[IndentingNewLine]Print[
          StyleForm["\<There is no periodic solution.\>", "\<Output\>", 
            FontFamily \[Rule] "\<Times-Plain\>", FontSize \[Rule] 12]]; 
        Label[2]; \[IndentingNewLine]Clear[X];]\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(syst\\)\\\" is similar to existing symbol \\\
\"\\!\\(sys\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon] \((x + y\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 1;\)\n\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        TagBox[
          
          StyleBox["\<\"The expansion of periodic motions to within terms of \
order \"\>",
            "Output",
            FontFamily->"Times-Plain",
            FontSize->12],
          (
          StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
            12]&)], "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        TagBox[
          StyleBox["\<\" are:\"\>",
            "Output",
            FontFamily->"Times-Plain",
            FontSize->12],
          (
          StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
            12]&)]}],
      SequenceForm[ 
        StyleForm[ 
        "The expansion of periodic motions to within terms of order ", 
          "Output", FontFamily -> "Times-Plain", FontSize -> 12], 2, 
        StyleForm[ 
        " are:", "Output", FontFamily -> "Times-Plain", FontSize -> 12]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"x", "\[InvisibleSpace]", 
        TagBox[
          StyleBox["\<\" = \"\>",
            "Output",
            FontFamily->"Times-Plain",
            FontSize->12],
          (
          StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
            12]&)], "\[InvisibleSpace]", \(X\ Cos[s] - 
          4\/3\ X\^2\ \[Epsilon]\ Sin[s\/2]\^4\)}],
      SequenceForm[ x, 
        StyleForm[ 
        " = ", "Output", FontFamily -> "Times-Plain", FontSize -> 12], 
        Plus[ 
          Times[ X, 
            Cos[ s]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ X, 2], \[Epsilon], 
            Power[ 
              Sin[ 
                Times[ 
                  Rational[ 1, 2], s]], 4]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"y", "\[InvisibleSpace]", 
        TagBox[
          StyleBox["\<\" = \"\>",
            "Output",
            FontFamily->"Times-Plain",
            FontSize->12],
          (
          StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
            12]&)], "\[InvisibleSpace]", \(\(-X\)\ Sin[s] + 
          1\/6\ X\ \[Epsilon]\ \((\(-3\) - 4\ X + 4\ X\ Cos[s])\)\ Sin[s]\)}],
      
      SequenceForm[ y, 
        StyleForm[ 
        " = ", "Output", FontFamily -> "Times-Plain", FontSize -> 12], 
        Plus[ 
          Times[ -1, X, 
            Sin[ s]], 
          Times[ 
            Rational[ 1, 6], X, \[Epsilon], 
            Plus[ -3, 
              Times[ -4, X], 
              Times[ 4, X, 
                Cos[ s]]], 
            Sin[ s]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      StyleBox["\<\"where\"\>",
        "Output",
        FontFamily->"Times-Plain",
        FontSize->12],
      (StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
        12]&)]], "Print"],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        TagBox[
          StyleBox["\<\"s = \"\>",
            "Output",
            FontFamily->"Times-Plain",
            FontSize->12],
          (
          StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
            12]&)], "\[InvisibleSpace]", \(t\ \((1 + \[Epsilon]\/2)\)\)}],
      SequenceForm[ 
        StyleForm[ 
        "s = ", "Output", FontFamily -> "Times-Plain", FontSize -> 12], 
        Times[ t, 
          Plus[ 1, 
            Times[ 
              Rational[ 1, 2], \[Epsilon]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    TagBox[
      StyleBox["\<\"Use GLindPoinc to compare graphically the numerical \
solution with the approximate one for a given value of the parameter in the \
time interval (T1,T2).\"\>",
        "Output",
        FontFamily->"Times-Plain",
        FontSize->12],
      (StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
        12]&)]], "Print"],

Cell[BoxData[
    TagBox[
      StyleBox["\<\"We suggest choosing the initial value list of x0 with the \
same length of periodic orbits.\"\>",
        "Output",
        FontFamily->"Times-Plain",
        FontSize->12],
      (StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
        12]&)]], "Print"],

Cell[BoxData[
    TagBox[
      StyleBox["\<\"When any orbit is periodic, the length of x0 is \
arbitrary.\"\>",
        "Output",
        FontFamily->"Times-Plain",
        FontSize->12],
      (StyleForm[ #, "Output", FontFamily -> "Times-Plain", FontSize -> 
        12]&)]], "Print"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 997}},
WindowSize->{1227, 740},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 8589, 151, 1110, "Input"],
Cell[10368, 206, 355, 5, 22, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10760, 216, 336, 9, 145, "Input"],
Cell[11099, 227, 975, 27, 25, "Print"],
Cell[12077, 256, 819, 25, 38, "Print"],
Cell[12899, 283, 859, 26, 38, "Print"],
Cell[13761, 311, 232, 7, 25, "Print"],
Cell[13996, 320, 45, 1, 25, "Print"],
Cell[14044, 323, 607, 18, 36, "Print"],
Cell[14654, 343, 36, 1, 25, "Print"],
Cell[14693, 346, 381, 9, 25, "Print"],
Cell[15077, 357, 318, 8, 25, "Print"],
Cell[15398, 367, 287, 8, 25, "Print"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

