(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22067,        745]*)
(*NotebookOutlinePosition[     23081,        779]*)
(*  CellTagsIndexPosition[     23037,        775]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 1", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Solution of ODEs and Their Properties",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.3  Functions DSolve, NDSolve", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"t", " ", 
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], 
          "==", \(x[t] + x[t]\^2 + t\^2\)}], ",", \(x[t]\), ",", "t"}], 
      "]"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "==", \(x[t]\/t + 3\ t\^3\)}], ",", \(x[\(-1\)] == 2\)}], "}"}],
         ",", \(x[t]\), ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox[
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "==", \(-Sin[x[t]]\)}], ",", \(x[0] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
          "}"}], ",", \(x[t]\), ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"1.5  Applications of the Programs Sysn, Phase2D, PolarPhase and Phase3D", 
  "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-x\)}]}], 
      ";"}], "\n", \(sys = {eq1, eq2};\), "\n", \(var = 
        t;\), "\n", \(data = {{0, 0.5, 0.5}, {1, 0.5, 0.5}, {2, 0.5, 
            0.5}};\), "\n", \(T1 = 15;\), "\n", \(index = {1, \ 2};\), "\n", 
    RowBox[{\(steps = 500;\), "\n"}], "\n", \(Sysn[sys, {x, y}, var, data, 
      T1, index, steps]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], 
          "==", \(2\ Sin[\(2\ y\)\/\(t + 1\)]\ Exp[\(-\(t\/3\)\)]\)}]}], 
      ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], 
          "==", \(2\ Cos[\(2\ x\)\/\(t + 1\)]\ Exp[\(-\(t\/3\)\)]\)}]}], 
      ";"}], "\n", \(sys = {eq1, eq2};\), "\n", \(unk = {x, 
          y};\), "\n", \(data = {{0, 1, 1}, {1, 1, 1}, {2, 1, 1}, {3, 1, 
            1}};\), "\n", \(T1 = 7;\), "\n", \(index = {1, \ 2};\), "\n", 
    RowBox[{\(steps = 3500;\), "\n"}], "\n", \(Sysn[sys, unk, t, data, T1, 
      index, steps]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-x\)}]}], ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {0, 0}, {0.2, 0}, {4, 0}, {0, 10}, 
      2000, {{\(-1.1\), 1.1}, {\(-1.1\), 1.1}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], 
          "==", \(\(-x\) + \((0.5 - x\^2)\)\ y\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[
        sys, {x, y}, {0, 0}, {0.5, 0.4}, {3, 0}, {\(-3.5\), 10}, 
        1000, {{\(-3\), 3}, {\(-2.5\), 2.5}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "==", \(r\ \((1 - r)\)\)}]}], 
      ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-1\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", \(unk = {r, \[CurlyPhi]}\), ";", 
      "\n", "\n", \(PolarPhase[sys, 
        unk, {0, 0}, {0.5, \[Pi]\/2}, {5, 4}, {\(-0.51\), 4}, 
        1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.13", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) - z\)}]}], ";", "\n", 
      RowBox[{
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "==", \(x + 0.2\ y\)}]}], 
        ";"}]}], "\n", 
    RowBox[{
      RowBox[{"eq3", "=", 
        RowBox[{
          SuperscriptBox["z", "\[Prime]",
            MultilineFunction->None], "==", \(0.2 + z\ \((x - 2.2)\)\)}]}], 
      ";", "\n", \(sys = {eq1, eq2, eq3}\), ";", "\n", 
      "\n", \(Phase3D[
        sys, {x, y, z}, {2, 2, 0}, {0, 0, 0}, {0, 0, 0}, {0, 60}, {0, 60}, 
        20000, All]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) - z\)}]}], ";", "\n", 
      RowBox[{
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "==", \(x + 0.2\ y\)}]}], 
        ";"}]}], "\n", 
    RowBox[{
      RowBox[{"eq3", "=", 
        RowBox[{
          SuperscriptBox["z", "\[Prime]",
            MultilineFunction->None], "==", \(0.2 + z\ \((x - 2.2)\)\)}]}], 
      ";", "\n", \(sys = {eq1, eq2, eq3}\), ";", "\n", 
      "\n", \(Phase3D[
        sys, {x, y, z}, {2, 2, 0}, {0, 0, 0}, {0, 0, 0}, {0, 60}, {50, 60}, 
        20000, All]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.14", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-6\)\ x - y - 3\ x\^2\)}]}], 
      ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {\(-1\), 1}, {0.5, 1.8}, {3, 1}, {\(-2\), 2}, 
      10000, {{\(-3.1\), 1.5}, {\(-3\), 2.5}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.15", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-10\)\ x + x\^3\)}]}], 
      ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {0, 0}, {2, 2.5}, {2, 2}, {\(-1\), 1}, 
      10000, {{\(-6\), 6}, {\(-10\), 10}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.16", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(y\ \((1 + y)\)\)}]}], 
      ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], 
          "==", \(\(-\(x\/2\)\) + y\/5 - x\ y + \(6\ y\^2\)\/5\)}]}], 
      ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {\(-1\), 0}, {0.6, 0.5}, {6, 1}, {\(-35\), 5}, 
      10000, {{\(-6\), 5}, {\(-3\), 3}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.17", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], 
          "==", \(3\ x\^4 - 12\ x\^2\ y\^2 + y\^4\)}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(6\ x\^3\ y - 10\ x\ y\^3\)}]}], 
      ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {0, 0}, {2, 2}, {3, 3}, {\(-0.2\), 0.2}, 
      20000, {{\(-4.5\), 4.5}, {\(-4.5\), 4.5}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.18", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(Sin[x\ y]\)}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(Cos[x\ y]\)}]}], ";"}], "\n", 
    RowBox[{\(sys = {eq1, eq2};\), "\n"}], "\n", \(Phase2D[
      sys, {x, y}, {\[Pi]\/2, \[Pi]\/2}, {0.4, 0.4}, {4, 4}, {\(-10\), 20}, 
      1000, {{0, \[Pi]}, {0, \[Pi]}}, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.6 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Yin-yang", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], 
          "==", \(y + x\ \((1 - x\^2 - y\^2)\)\)}]}], ";"}], "\n", 
    RowBox[{
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], 
          "==", \(\(-x\) + y\ \((1 - x\^2 - y\^2)\)\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[sys, {x, y}, {0, 0}, {0.4, 0.4}, {5, 5}, {0, 5}, 
        1000, {{\(-2\), 2}, {\(-2\), 2}}, 2]\)}]}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(y \((x\^2 - y\^2)\)\)}]}], ";", 
      "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\)\ \((x\^2 - y\^2)\)\)}]}],
       ";", "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[sys, {x, y}, {0, 0}, {0.4, 0.4}, {5, 5}, {\(-10\), 10}, 
        1000, {{\(-3\), 3}, {\(-3\), 3}}, 2]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Prey-predator model", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(x - x\ y\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-y\) + x\ y\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[sys, {x, y}, {1, 1}, {0.5, 0.5}, {2, 2}, {1, 10}, 
        1000, {{0, 2.8}, {0, 2.8}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Exercise ",
  StyleBox["4. Competing species model ",
    FontSize->14]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"eq1", "=", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "==", \(x - x\ y - 0.5  x\^2\)}]}], 
        ";", "\n", 
        RowBox[{"eq2", "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], 
            "==", \(\(-y\) + x\ y - 0.5  y\^2\)}]}], ";", 
        "\n", \(sys = {eq1, eq2}\), ";", "\n", 
        "\n", \(Phase2D[sys, {x, y}, {6/5, 2/5}, {0.5, 0.1}, {2, 4}, {0, 10}, 
          1000, {{0, 3}, {0, 1.5}}, 0]\)}], "\n"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Pendulum", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(-Sin[x]\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[sys, {x, y}, {0, 0}, {2.5, 0.5}, {7, 6}, {\(-10\), 10}, 
        1000, {{\(-16\), 16}, {\(-7\), 7}}, 0]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Pendulum with linear friction", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", "y"}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-Sin[x]\) - 0.1  y\)}]}], ";",
       "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(Phase2D[sys, {x, y}, {0, 0}, {3.5, 1}, {4, 4}, {\(-10\), 10}, 
        1000, {{\(-15\), 15}, {\(-10\), 10}}, 0]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "==", \(r\ \((1 - r\^2)\)\)}]}], ";", 
      "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-1\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(PolarPhase[
        sys, {r, \[CurlyPhi]}, {0, 0}, {0.5, \[Pi]\/2}, {3, 3}, {0, 5}, 
        1000, {{\(-1.5\), 1.5}, {\(-1.5\), 1.5}}, 1]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], 
          "==", \(r\ \((1 - r)\) \((2 - r)\)\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["\[CurlyPhi]", "\[Prime]",
            MultilineFunction->None], "==", \(-2\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(PolarPhase[
        sys, {r, \[CurlyPhi]}, {0, 0}, {0.2, \[Pi]\/2}, {12, 3}, {\(-25\), 
          0}, 3000, {{\(-3\), 3}, {\(-3\), 3}}, 2]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{972, 896},
WindowMargins->{{2, Automatic}, {Automatic, -1}},
PrintingCopies->1,
PrintingPageRange->{1, 1},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 132, 4, 141, "Title",
  Evaluatable->False],
Cell[1862, 58, 259, 10, 80, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2146, 72, 62, 1, 73, "Section"],
Cell[2211, 75, 536, 16, 39, "Text"],
Cell[2750, 93, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2895, 101, 146, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[3066, 107, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3183, 112, 402, 12, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3622, 129, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3739, 134, 432, 12, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4208, 151, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4325, 156, 686, 18, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5060, 180, 191, 4, 73, "Section"],

Cell[CellGroupData[{
Cell[5276, 188, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5393, 193, 730, 18, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6160, 216, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6277, 221, 853, 21, 279, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7167, 247, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7285, 252, 604, 16, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7926, 273, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8044, 278, 636, 17, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8717, 300, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8835, 305, 688, 18, 163, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9560, 328, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9678, 333, 829, 23, 140, "Input"],
Cell[10510, 358, 830, 23, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11377, 386, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11495, 391, 642, 17, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12174, 413, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12292, 418, 625, 17, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12954, 440, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13072, 445, 691, 19, 153, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13800, 469, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13918, 474, 683, 18, 121, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14638, 497, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[14756, 502, 633, 16, 142, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15438, 524, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[15591, 530, 123, 3, 57, "Subsection",
  Evaluatable->False],
Cell[15717, 535, 677, 18, 121, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16431, 558, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[16548, 563, 635, 16, 121, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17220, 584, 134, 3, 57, "Subsection",
  Evaluatable->False],
Cell[17357, 589, 593, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17987, 609, 189, 7, 57, "Subsection",
  Evaluatable->False],
Cell[18179, 618, 686, 18, 142, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18902, 641, 123, 3, 57, "Subsection",
  Evaluatable->False],
Cell[19028, 646, 592, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19657, 666, 144, 3, 57, "Subsection",
  Evaluatable->False],
Cell[19804, 671, 605, 15, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20446, 691, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[20563, 696, 648, 17, 143, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21248, 718, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[21365, 723, 662, 17, 142, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

