(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17512,        622]*)
(*NotebookOutlinePosition[     18446,        653]*)
(*  CellTagsIndexPosition[     18402,        649]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 10", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox["Rigid Body with a Fixed Point",
  FontSlant->"Italic"]], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.6 The Program Poinsot", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 10.1 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 0.5;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.5;\)\), "\n", 
    \(\(r0 = 3;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 3;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/2;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.2 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(r0 = 3;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 3;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/2;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.3 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 0.5;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.5;\)\), "\n", 
    \(\(r0 = 3;\)\), "\n", 
    \(\(\[Theta]0 = 0.05;\)\), "\n", 
    \(\(T = 4;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/20;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.4 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 0.5;\)\), "\n", 
    \(\(B = 1.5;\)\), "\n", 
    \(\(C0 = 1;\)\), "\n", 
    \(\(r0 = 1;\)\), "\n", 
    \(\(\[Theta]0 = \(-0.1\);\)\), "\n", 
    \(\(T = 30;\)\), "\n", 
    \(\(\[Alpha] = \[Pi];\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.7 The Program Solid", "Section",
  FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Example 10.5",
  FontFamily->"Times New Roman"]], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.1;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 3;\)\), "\n", 
    \(\(\[Psi]0 = 0;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, 1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.1;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 10;\)\), "\n", 
    \(\(\[Psi]0 = 0;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 5000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, 1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 0.9;\)\), "\n", 
    \(\(C0 = 1.1;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 3;\)\), "\n", 
    \(\(\[Psi]0 = 0;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, 1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 0.8;\)\), "\n", 
    \(\(C0 = 1.2;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 8;\)\), "\n", 
    \(\(\[Psi]0 = 0;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, 1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 0.8;\)\), "\n", 
    \(\(C0 = 1.2;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\) - Cos[\[Theta][t]]};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 6;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 10;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, 1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["10.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 2;\)\), "\n", 
    \(\(r0 = 2;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/5;\)\), "\n", 
    \(\(T = 5;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/2;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 3;\)\), "\n", 
    \(\(C0 = 5;\)\), "\n", 
    \(\(r0 = 2;\)\), "\n", 
    \(\(\[Theta]0 = \(-\[Pi]\)/20;\)\), "\n", 
    \(\(T = 5;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/10;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 5;\)\), "\n", 
    \(\(B = 3;\)\), "\n", 
    \(\(C0 = 1;\)\), "\n", 
    \(\(r0 = 2;\)\), "\n", 
    \(\(\[Theta]0 = \(-\[Pi]\)/20;\)\), "\n", 
    \(\(T = 5;\)\), "\n", 
    \(\(\[Alpha] = \[Pi]/15;\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 5;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 3;\)\), "\n", 
    \(\(r0 = 2;\)\), "\n", 
    \(\(\[Theta]0 = \(-\[Pi]\)/20;\)\), "\n", 
    \(\(T = 5;\)\), "\n", 
    \(\(\[Alpha] = \[Pi];\)\), "\n", 
    \(Poinsot[A, \ B, \ C0, \ r0, \ \[Theta]0, \ T, \ \[Alpha], 
      1000]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 1;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 10;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 10;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Exercise 6.",
  StyleBox[" ",
    FontWeight->"Plain"]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 6;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 10;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 1;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 20;\)\), "\n", 
    \(\(\[Psi]0 = 0;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, Sin[\[CurlyPhi][t]], \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0.2;\)\), "\n", 
    \(\(r0 = 4;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 10;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 0.5;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, 0, \(-1\)};\)\), "\n", 
    \(\(p0 = 1;\)\), "\n", 
    \(\(q0 = 0;\)\), "\n", 
    \(\(r0 = 5;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 40;\)\), "\n", 
    \(\(steps = 6000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 1;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 0.5;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, Sin[\[CurlyPhi][t]], \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0.2;\)\), "\n", 
    \(\(r0 = 8;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 3000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = 0.8;\)\), "\n", 
    \(\(B = 1;\)\), "\n", 
    \(\(C0 = 1.2;\)\), "\n", 
    \(\(va = {\[Psi], \[CurlyPhi], \[Theta], t};\)\), "\n", 
    \(\(z = {0, 0, 1};\)\), "\n", 
    \(\(F = {0, Sin[\[CurlyPhi][t]], \ \(-1\)};\)\), "\n", 
    \(\(p0 = 0;\)\), "\n", 
    \(\(q0 = 0.2;\)\), "\n", 
    \(\(r0 = 8;\)\), "\n", 
    \(\(\[Psi]0 = \(-\[Pi]\)/2;\)\), "\n", 
    \(\(\[CurlyPhi]0 = 0;\)\), "\n", 
    \(\(\[Theta]0 = \[Pi]/4;\)\), "\n", 
    \(\(T = 20;\)\), "\n", 
    \(\(steps = 5000;\)\), "\n", 
    \(Solid[A, \ B, \ C0, va, z, F, p0, q0, 
      r0, \[Psi]0, \[CurlyPhi]0, \ \[Theta]0, \ T, steps]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1052, 832},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 133, 4, 116, "Title",
  Evaluatable->False],
Cell[1912, 59, 236, 7, 63, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2173, 70, 62, 1, 91, "Section"],
Cell[2238, 73, 536, 16, 39, "Text"],
Cell[2777, 91, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2922, 99, 141, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3088, 105, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3207, 110, 411, 12, 203, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3655, 127, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3774, 132, 374, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4185, 148, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4304, 153, 374, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4715, 169, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4834, 174, 376, 11, 182, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5259, 191, 106, 1, 91, "Section"],

Cell[CellGroupData[{
Cell[5390, 196, 135, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5528, 201, 657, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6222, 224, 82, 2, 48, "Subsection",
  Evaluatable->False],
Cell[6307, 228, 658, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7002, 251, 82, 2, 48, "Subsection",
  Evaluatable->False],
Cell[7087, 255, 659, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7783, 278, 82, 2, 48, "Subsection",
  Evaluatable->False],
Cell[7868, 282, 659, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8564, 305, 82, 2, 48, "Subsection",
  Evaluatable->False],
Cell[8649, 309, 689, 18, 329, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9387, 333, 96, 1, 91, "Section"],

Cell[CellGroupData[{
Cell[9508, 338, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9625, 343, 372, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10034, 359, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10152, 364, 379, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10568, 380, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10685, 385, 379, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11101, 401, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11218, 406, 376, 11, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11631, 422, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11748, 427, 670, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12455, 450, 172, 7, 47, "Subsection",
  Evaluatable->False],
Cell[12630, 459, 669, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13336, 482, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13453, 487, 659, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14149, 510, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14266, 515, 689, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14992, 538, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15109, 543, 671, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15817, 566, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15935, 571, 689, 18, 329, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16661, 594, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16779, 599, 693, 18, 329, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

