(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18783,        648]*)
(*NotebookOutlinePosition[     19709,        679]*)
(*  CellTagsIndexPosition[     19665,        675]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 2", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Linear ODEs with Constant Coefficients ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"2.2  The General Solution of Linear Differential Systems with Constant \
Coefficients", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", \(y[t]\)}],
             ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(\(-\(5\/4\)\) x[t] - y[t]\)}]}], "}"}], ",", \({x[t], y[t]}\),
         ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-5\)/4, \(-1\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.3 The Program LinSys", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.2: Asymptotically stable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{\(A = {{\(-1\), 1}, {\(-1\), \(-1\)}}\), ";", 
      "\n", \(b = {0, 0}\), ";", "\n", \(unk = {x, y}\), ";", 
      "\n", \(unk0 = {x0, y0}\), ";", "\n", 
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\) + y\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\) - y\)}]}], ";", 
      "\n", \(sys = {eq1, eq2}\), ";", "\n", 
      "\n", \(LinSys[A, b, unk, unk0]\)}], "\n", \(Phase2D[
      sys, {x, y}, {0, 0}, {0.5, 0.5}, {2, 2}, {\(-16\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.3: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-3\), 0}, {0, \(-3\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == \(-3\)\ x;\)\), "\n", 
    \(\(eq2 = y' == \(-3\)\ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\ \n\), "\n", 
    \(LinSys[A, b, unk, unk0]\ \), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.4: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-1\), 1}, {0, \(-1\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == \(-x\) + y;\)\), "\n", 
    \(\(eq2 = y' == \ \(-y\);\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.5: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-2\), \(-3\)}, {0, \(-1\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == \(-2\)\ x - 3\ y;\)\), "\n", 
    \(\(eq2 = y' == \(-\ y\);\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.6:  Neutrally stable center", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-1\), 0}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == y;\)\), "\n", 
    \(\(eq2 = y' == \(-x\);\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {4, 0}, {\(-2\), 2}, 
      1000, {{\(-2.3\), 2.3}, {\(-2.3\), 2.3}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.7:  Unstable saddlepoint", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{1, 4}, {1, 1}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == x + 4  y;\)\), "\n", 
    \(\(eq2 = y' == x + \ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.8:  Unstable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{1, \(-1\)}, {1, 1}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == x - y;\)\), "\n", 
    \(\(eq2 = y' == x + \ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {2, 2}, {\(-5\), 5}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.9:  Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{2, 0}, {0, 2}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == 2  x;\)\), "\n", 
    \(\(eq2 = y' == 2\ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\ \n\), "\n", 
    \(LinSys[A, b, unk, unk0]\ \), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.10:  Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{2, 3}, {0, 1}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == 2\ x + 3\ y;\)\), "\n", 
    \(\(eq2 = y' == y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.4  Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{1, 1}, {0, 1}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == x + y;\)\), "\n", 
    \(\(eq2 = y' == \ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. Stable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-1\), \(-\(1\/2\)\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == y;\)\), "\n", 
    \(\(eq2 = y' == \(-x\) - 1\/2\ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {1\/2, 1\/2}, {3, 0}, {\(-15\), 15}, 
      1000, {{\(-40\), 40}, {\(-60\), 60}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-1\), 0}, {0, \(-5\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == \(-x\);\)\), "\n", 
    \(\(eq2 = y' == \(-5\)\ y;\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. Neutrally stable center", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 2}, {\(-1\), 0}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == 2  y;\)\), "\n", 
    \(\(eq2 = y' == \(-x\);\)\), "\n", 
    \(\(sys = {eq1, eq2};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {4, 0}, {\(-2\), 2}, 
      1000, {{\(-2.1\), 2.1}, {\(-1.6\), 1.6}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Unstable saddlepoint", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-1\), 0}, {0, 5}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\), "\n", 
    \(\(eq1 = x' == \(-x\);\)\), "\n", 
    \(\(eq2 = y' == 5\ y;\)\), "\n", 
    \(\(\(sys = {eq1, eq2};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\), "\n", 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Forced vibration", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-1\), \(-2\)}};\)\), "\n", 
    \(\(b = {0, Cos[t]};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\ \ \)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. Forced vibration", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-1\), 0}};\)\), "\n", 
    \(\(b = {0, Sin[2  t]};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(\(unk0 = {x0, y0};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-4\), 0}};\)\), "\n", 
    \(\(b = {0, Tan[t]};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(\(unk0 = {x0, y0};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-1\), 1}, {\(-1\), \(-1\)}};\)\), "\n", 
    \(\(b = {Cos[t], 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(\(unk0 = {x0, y0};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1}, {\(-9\), 0}};\)\), "\n", 
    \(\(b = {0, 1 - Exp[\(-t\)]};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(\(unk0 = {x0, y0};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{\(-1\), 0}, {0, 1}};\)\), "\n", 
    \(\(b = {0, Cos[t]};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, \(-1\)}, {\(-5\)/4, \(-1\)}};\)\), "\n", 
    \(\(b = {0, 0};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(unk0 = {x0, y0};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1, 0}, {0, 0, 1}, {1, 0, 0}};\)\), "\n", 
    \(\(b = {0, 0, t\ Exp[\(-t\)]};\)\), "\n", 
    \(\(unk = {x, y, z};\)\), "\n", 
    \(\(unk0 = {x0, y0, z0};\)\n\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(A = {{0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {1, 0, 0, 
            0}};\)\), "\n", 
    \(\(b = {0, 0, 0, Sin[t] + Cos[t]};\)\), "\n", 
    \(\(unk = {x1, x2, x3, x4};\)\), "\n", 
    \(\(\(unk0 = {x01, x02, x03, x04};\)\(\n\)
    \)\), "\n", 
    \(LinSys[A, b, unk, unk0]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{1140, 867},
WindowMargins->{{9, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 297, 11, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2233, 74, 62, 1, 91, "Section"],
Cell[2298, 77, 536, 16, 39, "Text"],
Cell[2837, 95, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2982, 103, 202, 4, 91, "Section"],

Cell[CellGroupData[{
Cell[3209, 111, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3326, 116, 613, 17, 59, "Input"],
Cell[3942, 135, 266, 7, 140, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4257, 148, 138, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[4420, 154, 143, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4566, 159, 774, 17, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5377, 181, 142, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5522, 186, 516, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6075, 203, 142, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6220, 208, 512, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6769, 225, 142, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6914, 230, 523, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7474, 247, 140, 3, 47, "Subsection",
  Evaluatable->False],
Cell[7617, 252, 502, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8156, 269, 137, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8296, 274, 499, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8832, 291, 131, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8966, 296, 499, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9502, 313, 130, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9635, 318, 496, 12, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10168, 335, 131, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10302, 340, 496, 12, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10847, 358, 129, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[11001, 364, 128, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11132, 369, 518, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11687, 387, 127, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11817, 392, 550, 13, 306, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12404, 410, 126, 3, 47, "Subsection",
  Evaluatable->False],
Cell[12533, 415, 535, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13105, 433, 138, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13246, 438, 531, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13814, 456, 135, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13952, 461, 538, 14, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14527, 480, 131, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14661, 485, 299, 8, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14997, 498, 131, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15131, 503, 306, 9, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15474, 517, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15591, 522, 303, 9, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15931, 536, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16048, 541, 313, 9, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16398, 555, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16516, 560, 312, 9, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16865, 574, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16983, 579, 290, 8, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17310, 592, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17428, 597, 297, 8, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17762, 610, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17880, 615, 320, 8, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18237, 628, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[18355, 633, 388, 10, 140, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

