(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23788,        843]*)
(*NotebookOutlinePosition[     24715,        874]*)
(*  CellTagsIndexPosition[     24671,        870]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 3", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Power Series Solution of ODEs \nand Frobenius Series",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.2  Power Series and the Program Taylor", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Examples relative to the built-in functions Series and Normal\
\>", 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Series[Sin[x], {x, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Normal[Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example relative to the program Taylor", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Taylor[Sin[x\ y], {x, y}, {0, 0}, 7]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.5 The Program SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Example 3.3: Material point subjected to an undamped and aging \
spring\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    StyleBox[
      RowBox[{
        RowBox[{"sys", "=", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "==", "y"}], ",", " ", 
              RowBox[{
                SuperscriptBox[
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "\[Prime]",
                  MultilineFunction->None], 
                "==", \(\(-Exp[\(-0.1\)\ t]\)\ x\)}]}], "}"}]}], ";", 
        "\n", \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}],
      FontSize->12]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 3.4:  Material point subjected to its weight and a \
resistence\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "u"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "w"}], ",", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-0.0001\) \(\@\(u\^2 + w\^2\)\) u\)}], ",", 
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-10\) - 0.0001 \(\@\( u\^2 + w\^2\)\) w\)}]}], 
          "}"}]}], ";", "\n", \(unk = {x, y, u, w}\), ";", 
      "\n", \(unk0 = {0, 0, 100\ Cos[45\ Degree], 100\ Sin[45\ Degree]}\), 
      ";", "\n", 
      "\n", \(SerSol[sys, unk, t, unk0, 4, 0, 14, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.6 Other Applications of SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.5: Airy's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-t\)\ x\)}]}], "}"}]}], 
      ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {1, 1}, 6, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.6: Mathieu's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-\((1 - Cos[t])\)\)\ x\)}]}], "}"}]}], ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]\[Prime]",
              MultilineFunction->None], "==", \(t\^2 + x\^2\)}], "}"}]}], ";",
       "\n", "\n", \(SerSol[sys, {x}, t, {0}, 11, 0, 1.9, 2000]\)}]], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.8: Hermite's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(2\ t\ y - 6  x\)}]}], 
          "}"}]}], ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {0, \(-12\)}, 4, 0, 4, 
        2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.7 The Program Frobenius", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(\(x\)\(\ \)\)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(x\ y\)}], " ", "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 3, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\ \)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{\(eq = \(\(\(x\)\(\ \)\)\^2\) \(y'\)' + 
            x\ \((1 + x)\) y' - \((1 + x\^3)\) y\  == 0\), ";", 
      "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", "\n", 
      StyleBox[\(Frobenius[eq, unk, var, 
          5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\),
        FontSize->12]}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      StyleBox[\(eq = \(\(\(x\)\(\ \)\)\^2\) \(y'\)' + 
              x\ \((5 + x\^2)\) y' + \((4 + x\^2)\) y\  == 0\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(unk = y\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(var = x\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], "\n", 
      "\n", \(Frobenius[eq, unk, var, 
        5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"Frobenius", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(\(\(x\)\(\ \)\)\/2\), 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], 
            "+", \(1\/4\ \((x - Sin[x])\)\ x\ y\)}], "==", "0"}], ",", "y", 
        ",", "x", ",", "7", ",", \({0.2, 5}\), ",", 
        RowBox[{"{", 
          RowBox[{\(y[0.2] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0.2", "]"}], "==", 
              "0.5"}]}], "}"}], ",", "1000"}], "]"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-4\)\ x + t\ Cos[t]\)}]}],
           "}"}]}], ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 1.5, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(x - y + 2\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(y - \ x + t\)}]}], " ", 
          "}"}]}], ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(y + Exp[t]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x + Sin[t]\)}]}], "}"}]}], 
      ";", "\n", 
      "\n", \(SerSol[sys, {x, y}, t, {0, 1}, 5, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "z"}], ",", 
            RowBox[{
              SuperscriptBox["z", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-6\)\ x - 11\ y - 6\ z + Exp[\(-t\)]\)}]}], " ", 
          "}"}]}], ";", "\n", 
      "\n", \(SerSol[sys, {x, y, z}, t, {0, 1, 0}, 20, 0, 2, 
        2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(-Sin[y]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x\^2\)}]}], "}"}]}], ";", 
      "\n", "\n", \(SerSol[sys, {x, y}, t, {1, 0.5}, 4, 0, 1, 
        2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(\(x\^3\) y\)}], "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 6, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(\(\(x\)\(\ \)\)\^2\) \(y'\)' + x\ y' + 3  x\^2\ y\  == 
          0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(\(var = x;\)\(\n\)
    \)\), "\n", 
    \(Frobenius[eq, unk, var, 
      10, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", \(\((1\/8 + x\^4)\)\ y\)}], "==",
           "0"}]}], ";", 
      "\n", \(Frobenius[eq, y, x, 8, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(eq = \(\(\(x\)\(\ \)\)\^2\) \(y'\)' + x\ \ y' + 2  x\ y\  == 
          0;\)\(\n\)
    \)\), "\n", 
    \(Frobenius[eq, y, x, 6, {0.3, 3}, {y[0.3] == 0, \(y'\)[0.3] == 1}, 
      1000]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(\(x\)\(\ \)\)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(x\ \ y\)}], " ", "==", 
          "0"}]}], ";", "\n", 
      "\n", \(Frobenius[eq, y, x, 5, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", \(Frobenius[eq, y, x, 
        3, {0.5, 5}, {y[0.5] == 1, \(y'\)[0.5] == 3}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\ \(y'\)[x] + y[x] == 0, y[x], 
      x]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\^2\ \(y'\)[x] + y[x] == 0, y[x], 
      x]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(\((x\^2 + 1)\) y\)}], "==",
           "0"}]}], ";", "\n", 
      "\n", \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\ \ \(y'\)[x] + \((x\^2 + 1)\) y[x] == 
        0, y[x], x]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], 
            "+", \(\((x\^2 - 1)\) \((x\^2 + 4)\) y\)}], "==", "0"}]}], ";", 
      "\n", "\n", \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            FractionBox[
              RowBox[{"x", " ", 
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None]}], "2"], 
            "+", \(1\/4\ x\ Cos[x]\ y\)}], "==", "0"}]}], ";", "\n", 
      "\n", \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{1149, 911},
WindowMargins->{{25, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 258, 9, 100, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2194, 72, 62, 1, 91, "Section"],
Cell[2259, 75, 536, 16, 39, "Text"],
Cell[2798, 93, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2943, 101, 156, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3124, 107, 175, 6, 47, "Subsection",
  Evaluatable->False],
Cell[3302, 115, 133, 4, 35, "Input"],
Cell[3438, 121, 147, 4, 35, "Input"],
Cell[3588, 127, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3780, 136, 141, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3924, 141, 144, 4, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4117, 151, 138, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[4280, 157, 182, 6, 47, "Subsection",
  Evaluatable->False],
Cell[4465, 165, 707, 19, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5209, 189, 182, 6, 47, "Subsection",
  Evaluatable->False],
Cell[5394, 197, 1011, 25, 136, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6454, 228, 148, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[6627, 234, 131, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6761, 239, 534, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7332, 259, 134, 3, 47, "Subsection",
  Evaluatable->False],
Cell[7469, 264, 557, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8063, 284, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8180, 289, 381, 11, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8598, 305, 135, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8736, 310, 558, 16, 77, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9343, 332, 141, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[9509, 338, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9626, 343, 609, 15, 120, "Input"],
Cell[10238, 360, 35, 1, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10310, 366, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10428, 371, 417, 9, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10882, 385, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11001, 390, 693, 23, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11731, 418, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11849, 423, 945, 24, 59, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12843, 453, 128, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[12996, 459, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13113, 464, 552, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13702, 484, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13819, 489, 555, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14411, 509, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14528, 514, 546, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15111, 534, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15228, 539, 731, 20, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15996, 564, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16113, 569, 541, 15, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16691, 589, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16808, 594, 469, 12, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17314, 611, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17431, 616, 364, 10, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17832, 631, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17949, 636, 508, 14, 82, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18494, 655, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[18611, 660, 298, 8, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18946, 673, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[19064, 678, 434, 12, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19535, 695, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[19653, 700, 568, 15, 78, "Input"],
Cell[20224, 717, 182, 5, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20443, 727, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[20561, 732, 529, 14, 78, "Input"],
Cell[21093, 748, 185, 5, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21315, 758, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[21433, 763, 553, 15, 78, "Input"],
Cell[21989, 780, 201, 5, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22227, 790, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[22345, 795, 570, 15, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22952, 815, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[23070, 820, 678, 18, 105, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

