(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11631,        448]*)
(*NotebookOutlinePosition[     12566,        479]*)
(*  CellTagsIndexPosition[     12522,        475]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 5", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Problems of Stability",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.5 The Program Liapunov", "Section",
  FontFamily->"Times New Roman"]], "Section",
  TextAlignment->Left,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == y + x\ y\^4 - 2  x\^3, 
          y' == 2\ x + 2\ x\^2\ y\^3 - y\^7};\)\(\n\)
    \)\), "\n", 
    \(Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 
      50]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.4 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-\ y\), y' == \(-x\) - 2\ y - y\^3};\)\(\n\)
    \)\), "\n", 
    \(Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 0.6, 
      0.75, 50]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-x\) + \ y, y' == \(-x\) - y - x\^3};\)\(\n\)
    \)\), "\n", 
    \(Liapunov[sys, {x, y}, x\^2 + x\ y + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 
      1.4, 1, 50]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.6 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-\ x\), y' == \(-y\) + y\^2};\)\(\n\)
    \)\), "\n", 
    \(Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 0.5, 
      0.75, 50]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-y\) - x\ \((x\^2 + y\^2)\), 
          y' == x - y\ \((x\^2 + y\^2)\)};\)\(\n\)
    \)\), "\n", 
    \(Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 
      50]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.7 The Program LStability", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == 2\ x\ y, y' == 1 - 3\ x\^2 - y\^2};\)\), "\n", 
    \(\(\(xe = {{0, \(-1\)}, {0, 1}, {\(-1\)/\@3, 0}, {1/\@3, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.9 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y};\)\), "\n", 
    \(\(\(xe = {{0, 0}, {1/2, 1/2}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == x + y, y' == 2\ x\ y};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) + y == 0, \(-x\) + 2\ x\ y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y};\)\), "\n", 
    \(\(\(xe = {{1/2, 1/2}, {0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \(-x\) + y, y' == \(-x\) - y};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{x - y == 0, \(-x\) - y - x\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == x - y, y' == \(-x\) - y - x\^3};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{y == 0, \(-x\) + \((1\/2 - x\^2)\) y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) + \((1\/2 - x\^2)\) y};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \(-2\)\ x - y - x\ \((x\^2 + y\^2)\), 
          y' == x - y + y\ \((x\^2 + y\^2)\)};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\((1 + x)\) Sin[x - 3\ y] == 0, 1 - x - Cos[y] == 0}, {x, 
        y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == \((1 + x)\) Sin[x - 3\ y], 
          y' == 1 - x - Cos[y]};\)\), "\n", 
    \(\(\(xe = {{0, 0}, {\(-1\), \(-ArcCos[2]\)}, {\(-1\), 
            ArcCos[2]}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \((1 + y)\) - Exp[\(-x\)], 
          y' == y - Sin[x]};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) == 0, \(-y\) + y\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == \(-x\), y' == \(-y\) + y\^3};\)\), "\n", 
    \(\(\(xe = {{0, 0}, {0, \(-1\)}, {0, 1}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\)};\)\), "\n", 
    \(\(\(xe = {{0, 0}};\)\(\n\)
    \)\), "\n", 
    \(LStability[sys, {x, y}, xe]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1148, 905},
WindowMargins->{{7, Automatic}, {-3, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 132, 4, 141, "Title",
  Evaluatable->False],
Cell[1862, 58, 243, 10, 80, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2130, 72, 62, 1, 73, "Section"],
Cell[2195, 75, 536, 16, 39, "Text"],
Cell[2734, 93, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2879, 101, 163, 3, 73, "Section"],

Cell[CellGroupData[{
Cell[3067, 108, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3185, 113, 308, 8, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3530, 126, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3649, 131, 282, 7, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3968, 143, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4087, 148, 287, 7, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4411, 160, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4530, 165, 275, 7, 79, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4842, 177, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4960, 182, 313, 8, 79, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5322, 196, 142, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[5489, 202, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5607, 207, 298, 7, 117, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5942, 219, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6061, 224, 269, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6367, 236, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6486, 241, 243, 7, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6778, 254, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[6931, 260, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7049, 265, 163, 4, 35, "Input"],
Cell[7215, 271, 269, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7521, 283, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7638, 288, 251, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7926, 300, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8043, 305, 159, 4, 36, "Input"],
Cell[8205, 311, 253, 7, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8495, 323, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8612, 328, 166, 4, 59, "Input"],
Cell[8781, 334, 260, 7, 124, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9078, 346, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9195, 351, 306, 8, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9538, 364, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9655, 369, 185, 5, 35, "Input"],
Cell[9843, 376, 341, 9, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10221, 390, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10338, 395, 277, 8, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10652, 408, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10769, 413, 156, 4, 36, "Input"],
Cell[10928, 419, 271, 7, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11236, 431, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11353, 436, 238, 7, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

