(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13242,        491]*)
(*NotebookOutlinePosition[     14238,        524]*)
(*  CellTagsIndexPosition[     14194,        520]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 6", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Stability: The Critical Case",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"6.3 The Programs CriticalEqS and CriticalEqN", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {u' == \(-v\) - a\ \[Lambda]\ v\^2 - \(1\/3\) a\ v\^3, 
          v' == u - \[Lambda]\ v\^2 - \(1\/3\) v\^3};\)\), "\n", 
    \(\(unk = {u, v};\)\), "\n", 
    \(\(\(order = 10;\)\(\n\)
    \)\), "\n", 
    \(CriticalEqS[sys, unk, order]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {u' == \(-v\) - v\^3\/\(6\ \[Lambda]\^2\) - 
              v\^2\/\(2\ \[Lambda]\), 
          v' == u - v\^3\/3 - v\^2\ \[Lambda]};\)\), "\n", 
    \(\(unk = {u, v};\)\), "\n", 
    \(\(\(order = 10;\)\(\n\)
    \)\), "\n", 
    \(CriticalEqS[sys, unk, order]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == x + y + x\^2 + 2\ x\ y + \(x\^2\) y, 
          y' == \(-2\)\ x - y - x\^2 - 2\ x\ y - x\^2\ y};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(CriticalEqN[sys, unk]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.002, 0}, {2, 2}, {0, 800}, 
      5000, {{\(-0.006\), 0.006}, {\(-0.008\), 0.008}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-3\)\ y - x\ \((x\^2 + y\^2)\)\^3, 
          y' == 3\ x - y \((x\^2 + y\^2)\)\^3};\)\(\n\)
    \)\), "\n", 
    \(CriticalEqS[sys, {x, y}, 10]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.02, 0.02}, {3, 0}, {\(-80\), 120}, 
      5000, {{\(-0.06\), 0.06}, {\(-0.06\), 0.06}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {2, 0}, {20, 100}, 
      5000, {{\(-0.5\), 0.5}, {\(-0.5\), 0.5}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.002, 0.002}, {3, 0}, {0, 200}, 
      5000, {{\(-0.006\), 0.006}, {\(-0.006\), 0.006}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-\ y\) + 0.1\ x\ y\^2, 
          y' == x - 0.1\ y\ x\^2};\)\(\n\)
    \)\), "\n", 
    \(CriticalEqN[sys, {x, y}]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(\(sys = {x' == \(-\ y\) + \(\(1\)\(\ \)\)\/10\ x\ y\^2, 
          y' == x - \(\(1\)\(\ \)\)\/10\ y\ x\^2};\)\(\n\)
    \)\), "\n", 
    \(CriticalEqS[sys, {x, y}, 20]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {5, 0}, {0, 120}, 
      5000, {{\(-1\), 1}, {\(-1\), 1}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(\(sys = {x' == y, y' == \(-x\) - \ x\^3};\)\(\n\)
    \)\), "\n", 
    \(CriticalEqS[sys, {x, y}, 20]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {5, 0}, {0, 20}, 
      5000, {{\(-1.2\), 1.2}, {\(-1.4\), 1.4}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.5 The Program CManifold", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == y, 
            y' == \(-x\) - x\ z}, {z' == \(-z\) - c\ x\^2}};\)\), "\n", 
    \(\(\(unk = {{x, y}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(x\^2\) \((x\^2 + y\^2 + z\^2)\), 
            y' == \(-y\^2\) \((x\^2 + y\^2 + 
                    z\^2)\)}, {z' == \(-z\) + \(x\^2\) \((x\^2 + y\^2 + 
                      z\^2)\)}};\)\), "\n", 
    \(\(\(unk = {{x, y}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \[Epsilon]\ x - x\^3 + x\ y, \[Epsilon]' == 
              0}, {y' == \(-y\) + y\^2 - x\^2}};\)\), "\n", 
    \(\(\(unk = {{x, \[Epsilon]}, {y}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.6 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(-x\^3\)}, {y' == \(-y\) + x\^2}};\)\), "\n", 
    \(\(\(unk = {{x}, {y}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 4]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(-x\^2\) \((x\^2 + y\^2 + 
                    z\^2)\)}, {y' == \(-y\) - \(x\^2\) \((x\^2 + y\^2 + 
                      z\^2)\), 
            z' == \(-z\) + \(x\^2\) \((x\^2 + y\^2 + z\^2)\)}};\)\), "\n", 
    \(\(\(unk = {{x}, {y, z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(-x\^2\)}, {y' == \(-y\)}};\)\), "\n", 
    \(\(\(unk = {{x}, {y}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == 0, \[Lambda]' == 
              0}, {y' == \[Lambda]\ x - y}};\)\), "\n", 
    \(\(\(unk = {{x, \[Lambda]}, {y}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(-y\) + x\ y, 
            y' == x - x\ y\^2}, {z' == \(-z\) + x\ z\^2}};\)\), "\n", 
    \(\(\(unk = {{x, y}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 4]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \[Mu]\ x + y, 
            y' == \(-x\) + \[Mu]\ x - x\ z, \[Mu]' == 
              0}, {z' == \(-z\) - c\ x\^2}};\)\), "\n", 
    \(\(\(unk = {{x, y, \[Mu]}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == 0, \[Lambda]' == 
              0}, {y' == \[Lambda]\ x - y}};\)\), "\n", 
    \(\(\(unk = {{x, \[Lambda]}, {y}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \(-y\) + x\ y, 
            y' == x - x\ y\^2}, {z' == \(-z\) + x\ z\^2}};\)\), "\n", 
    \(\(\(unk = {{x, y}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 4]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {{x' == \[Mu]\ x + y, 
            y' == \(-x\) + \[Mu]\ y - x\ z, \[Mu]' == 
              0}, {z' == \(-z\) + x\^2}};\)\), "\n", 
    \(\(\(unk = {{x, y, \[Mu]}, {z}};\)\(\n\)
    \)\), "\n", 
    \(CManifold[sys, unk, 3]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1019, 815},
WindowMargins->{{8, Automatic}, {Automatic, 7}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 132, 4, 141, "Title",
  Evaluatable->False],
Cell[1862, 58, 234, 9, 80, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2121, 71, 62, 1, 73, "Section"],
Cell[2186, 74, 536, 16, 39, "Text"],
Cell[2725, 92, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2870, 100, 161, 3, 73, "Section"],

Cell[CellGroupData[{
Cell[3056, 107, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3174, 112, 355, 9, 145, "Input"],
Cell[3532, 123, 377, 10, 150, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3946, 138, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4064, 143, 310, 8, 99, "Input"],
Cell[4377, 153, 226, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4640, 163, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4758, 168, 272, 7, 83, "Input"],
Cell[5033, 177, 230, 5, 35, "Input"],
Cell[5266, 184, 219, 5, 35, "Input"],
Cell[5488, 191, 230, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5755, 201, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5873, 206, 243, 7, 78, "Input"],
Cell[6119, 215, 279, 7, 103, "Input"],
Cell[6401, 224, 210, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6648, 234, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6766, 239, 213, 6, 78, "Input"],
Cell[6982, 247, 217, 5, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7248, 258, 141, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[7414, 264, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7532, 269, 287, 8, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7856, 282, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7974, 287, 410, 10, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8421, 302, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8539, 307, 325, 8, 99, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8913, 321, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[9066, 327, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9183, 332, 255, 7, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9475, 344, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9592, 349, 419, 10, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10048, 364, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10165, 369, 248, 7, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10450, 381, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10567, 386, 293, 8, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10897, 399, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11014, 404, 297, 8, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11348, 417, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11465, 422, 344, 9, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11846, 436, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11963, 441, 293, 8, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12293, 454, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12410, 459, 297, 8, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12744, 472, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12861, 477, 341, 9, 99, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

