(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20038,        800]*)
(*NotebookOutlinePosition[     20973,        831]*)
(*  CellTagsIndexPosition[     20929,        827]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 7", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Bifurcation in ODEs",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.3 The Programs Bif1 and Bif1G", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = u' == \[Alpha] + u;\)\), "\n", 
    \(\(unk = u;\)\), "\n", 
    \(\(\(par = \[Alpha];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\(\(\n\)\(Bif1G[eq, unk, par, 1, 1, 20]\)\)\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = u' == \[Alpha] - u\^2;\)\), "\n", 
    \(\(unk = u;\)\), "\n", 
    \(\(\(par = \[Alpha];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \((\[Lambda]\ x - x\^3)\) \((\((\[Lambda] + 2)\) + x\^2 + 
                1)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \((\[Lambda] + x - x\^3)\) \((\[Lambda]\^2 + x\^2 - 
                1)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.4 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = u' == \[Alpha] + u\^2;\)\), "\n", 
    \(\(unk = u;\)\), "\n", 
    \(\(\(par = \[Alpha];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = u' == \[Alpha] + \[Alpha]\ u\^2 + u\^3;\)\), "\n", 
    \(\(unk = u;\)\), "\n", 
    \(\(\(par = \[Alpha];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] - \(x\^2\) \((1 + x\^2)\)\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] + x\^4;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Mu]\ \ x\^2 + x\^4;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Mu];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] - x\^2\/\(1 + x\^2\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] - x\^2\/\((1 + x\^2)\)\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] - x\/\(1 + x\^2\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \((\[Lambda] - x\^2)\)\ \((3\ \[Lambda] - x + 1)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \((\[Lambda] - x)\)\ \((\[Lambda] - x\^2)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \((\(-\[Lambda]\) - x)\)\ \((\[Lambda] - x\^2)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 1, 20]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \((\[Lambda] - x)\)\ \((\[Lambda] - 2\ x\^2)\);\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = \[Lambda];\)\(\n\)
    \)\), "\n", 
    \(Bif1[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif1G[eq, unk, par, 1, 0.5, 50]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.6 The Programs Bif2 and Bif2G", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] + \[Mu]\ x + x\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(par = {\[Lambda], \[Mu]};\)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] + \[Mu]\ x - x\^3;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(par = {\[Lambda], \[Mu]};\)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\ \)], "Input"],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.7 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \[Lambda] + \[Mu]\ x\^2 - x\^3 + \[Lambda]\ x\^4;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(par = {\[Lambda], \[Mu]};\)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = x' == \[Lambda] + \((\[Mu] - \[Lambda])\)\ x + x\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(par = {\[Lambda], \[Mu]};\)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.02]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \[Lambda]\^2 + 2\ \[Mu]\ \[Lambda]\ x + \[Mu] + 
            x\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = {\[Lambda], \[Mu]};\)\(\n\)
    \)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.01]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(eq = 
        x' == \[Lambda]\^2 + 2\ \[Mu]\ \[Lambda]\ x + \[Mu] + 
            x\^2;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = {\[Mu], \[Lambda]};\)\(\n\)
    \)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 
        x' == \[Lambda] + \[Mu] + \[Lambda]\^2\ x + \[Mu]\ x\^2 - 
            x\^3;\)\), "\n", 
    \(\(unk = x;\)\), "\n", 
    \(\(\(par = {\[Lambda], \[Mu]};\)\(\n\)
    \)\), "\n", 
    \(Bif2[eq, unk, par]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Bif2G[eq, unk, par, 1, 1, 50, 0.01]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.9 The Program HopfBif", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \[Epsilon]\ x - 3\ y + x\ \((x\^2 + y\^2)\)\^3, 
          y' == 3\ x - \[Epsilon]\ y + y\ \((x\^2 + y\^2)\)\^3};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, unk, \[Epsilon], {\(-1\), 1}, {0.4, 6}, {0, 0}, {0, 4}, 
      300]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == x + y, 
          y' == \((\[Epsilon] - 2)\) x + \((\[Epsilon] - 1)\) y - 
              x\^3 - \(x\^2\) y};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, unk, \[Epsilon], {\(-1\), 1}, {0.4, 6}, {0, 0}, {0, 4}, 
      300]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \[Lambda]\ x + y - x \((x\^2 + y\^2)\), 
          y' == \(-x\) + \[Lambda]\ y - y \((x\^2 + y\^2)\)};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, 
      unk, \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 
      500]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.10 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) + \[Lambda]\ y - y\^3};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(par = \[Lambda];\)\), "\n", 
    \(\(valpar = {\(-0.5\), 0.5};\)\), "\n", 
    \(HopfBif[sys, unk, par, valpar, {0.2, 10}, {0, 0}, {0, 6}, 
      500]\ \)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \[Lambda]\ x + \((\[Lambda] - 2)\) y, 
          y' == \(-\((\[Lambda] - 2)\)\) x + \[Lambda]\ \ y - y\ x\^2 + 
              y\^3};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, 
      unk, \[Lambda], {\(-0.2\), 0.2}, {0.02, 10}, {0, 0}, {0, 2}, 
      500]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == 
            2\ \[Lambda]\ x + \((\[Lambda] - 1)\) y - x \((x\^2 + y\^2)\), 
          y' == \(-\((\[Lambda] + 1)\)\) x + 2\ \[Lambda]\ y - 
              y \((x\^2 + y\^2)\)};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, 
      unk, \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 
      500]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) + \[Lambda]\ y - y \((x\^2 + y\^2)\)};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, 
      unk, \[Lambda], {\(-0.5\), 0.5}, {0.1, 10}, {0, 0}, {0, 6}, 
      500]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == \[Lambda]\ x + y + \((x\ y + x\ y\^2)\)\^2, 
          y' == \(-x\) + \[Lambda]\ y - \((x\^2 + y\^2)\)};\)\), "\n", 
    \(\(\(unk = {x, y};\)\(\n\)
    \)\), "\n", 
    \(HopfBif[sys, 
      unk, \[Lambda], {\(-0.5\), 0.5}, {0.0005, 20}, {0, 0}, {0, 4}, 
      1500]\ \)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1115, 911},
WindowMargins->{{14, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 132, 4, 141, "Title",
  Evaluatable->False],
Cell[1862, 58, 225, 9, 80, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2112, 71, 62, 1, 73, "Section"],
Cell[2177, 74, 536, 16, 39, "Text"],
Cell[2716, 92, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2861, 100, 147, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[3033, 106, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3150, 111, 227, 7, 119, "Input"],
Cell[3380, 120, 125, 3, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3542, 128, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[3659, 133, 230, 7, 120, "Input"],
Cell[3892, 142, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4040, 150, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4157, 155, 304, 9, 120, "Input"],
Cell[4464, 166, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4612, 174, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[4729, 179, 298, 9, 120, "Input"],
Cell[5030, 190, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5190, 199, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[5343, 205, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5461, 210, 230, 7, 120, "Input"],
Cell[5694, 219, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5842, 227, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[5960, 232, 247, 7, 120, "Input"],
Cell[6210, 241, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6358, 249, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6476, 254, 254, 7, 121, "Input"],
Cell[6733, 263, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6881, 271, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[6999, 276, 232, 7, 120, "Input"],
Cell[7234, 285, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7382, 293, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[7500, 298, 232, 7, 120, "Input"],
Cell[7735, 307, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7883, 315, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8001, 320, 246, 7, 150, "Input"],
Cell[8250, 329, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8398, 337, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[8516, 342, 251, 7, 155, "Input"],
Cell[8770, 351, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8918, 359, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9036, 364, 243, 7, 142, "Input"],
Cell[9282, 373, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9430, 381, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[9548, 386, 275, 8, 120, "Input"],
Cell[9826, 396, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9974, 404, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10093, 409, 259, 7, 120, "Input"],
Cell[10355, 418, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10503, 426, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[10622, 431, 273, 8, 120, "Input"],
Cell[10898, 441, 111, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11046, 449, 116, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11165, 454, 271, 8, 120, "Input"],
Cell[11439, 464, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11601, 473, 147, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[11773, 479, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[11891, 484, 237, 6, 99, "Input"],
Cell[12131, 492, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12285, 500, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[12402, 505, 237, 6, 99, "Input"],
Cell[12642, 513, 35, 1, 35, "Input"],
Cell[12680, 516, 117, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12846, 525, 128, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[12999, 531, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13117, 536, 267, 7, 99, "Input"],
Cell[13387, 545, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13541, 553, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[13659, 558, 255, 6, 99, "Input"],
Cell[13917, 566, 117, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14071, 574, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[14189, 579, 299, 9, 120, "Input"],
Cell[14491, 590, 117, 3, 35, "Input"],
Cell[14611, 595, 299, 9, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14947, 609, 115, 3, 57, "Subsection",
  Evaluatable->False],
Cell[15065, 614, 303, 9, 120, "Input"],
Cell[15371, 625, 117, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15537, 634, 139, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[15701, 640, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[15818, 645, 360, 8, 104, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16215, 658, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[16332, 663, 355, 9, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16724, 677, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[16841, 682, 360, 9, 99, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17250, 697, 129, 2, 73, "Section"],

Cell[CellGroupData[{
Cell[17404, 703, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[17521, 708, 345, 8, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17903, 721, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[18020, 726, 391, 10, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18448, 741, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[18565, 746, 434, 11, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19036, 762, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[19153, 767, 323, 9, 99, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19513, 781, 114, 3, 57, "Subsection",
  Evaluatable->False],
Cell[19630, 786, 368, 9, 104, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

