(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19879,        692]*)
(*NotebookOutlinePosition[     20814,        723]*)
(*  CellTagsIndexPosition[     20770,        719]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 8", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["The Lindstedt-Poincar\[EAcute] Method",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
" 8.3 The Programs LindPoic and GLindPoinc", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 8.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\^3};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 2;\)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(r = 0.1;\)\), "\[IndentingNewLine]", 
    \(\(x0 = {0.3, 0.6, 0.9, 1.2};\)\), "\[IndentingNewLine]", 
    \(GLindPoinc[sys, unk, var, par, r, x0, {0, 50}, 2]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.5 bis", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\^3};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 2;\)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(r = 0.1;\)\), "\[IndentingNewLine]", 
    \(\(x0 = {0.3, 0.6, 0.9, 1.2};\)\), "\[IndentingNewLine]", 
    \(GLindPoinc[sys, unk, var, par, r, x0, {0, 50}, 2]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon] \((x + y\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 1;\)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.6 bis", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon] \((x + y\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(m = 2;\)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}, 
      2]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon]\ y \((9 - x\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.08, {6}, {0, 10}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) + \[Epsilon]\ y \((9 - x\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.07, {6}, {0, 10}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8 bis", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) + \[Epsilon]\ y \((9 - x\^2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(\(m = 2;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.07, {6}, {0, 10}, 2]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) + \[Mu]\ y \((1 - x + y)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Mu];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) + \[Mu] \((y - y\^3\/3)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Mu];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.6, {2}, {0, 10}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) + \[Mu] \((y - y\^3\/3)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Mu];\)\), "\n", 
    \(\(\(m = 2;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.6, {2}, {0, 10}, 2]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\ \ y\^2};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.5, 0.8}, {0, 20}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y, 
          y' == \(-x\) - \[Epsilon]\ \((x\^2 + y\^2 - 2)\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Epsilon];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {0.5, 1, 1.5}, {0, 20}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(sys = {x' == y - \[Mu]\ y\^2, 
          y' == \(-x\) + \[Mu]\ y\^2\/\(x\^2 + y\^2 - 1\)};\)\), "\n", 
    \(\(unk = {x, y};\)\), "\n", 
    \(\(var = t;\)\), "\n", 
    \(\(par = \[Mu];\)\), "\n", 
    \(\(\(m = 1;\)\(\n\)
    \)\), "\n", 
    \(LindPoinc[sys, unk, var, par, m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {0.00006, 0.0002}, {0, 50}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(CriticalEqS[sys, unk, 6]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.13", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ x\ \((x\^2 + 4  y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ y\ \((x\^2 + 4  y\^2 - 4)\)\)}]}], 
          "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), 
      ";"}], "\n", \(par = \[Mu];\), "\n", 
    RowBox[{\(m = 1;\), "\n"}], "\n", \(LindPoinc[sys, unk, var, par, 
      m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.07, {2\ \@\(2/5\)}, {0, 10}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ x\ \((x\^2 + 4  y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ y\ \((x\^2 + 4  y\^2 - 4)\)\)}]}], 
          "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), 
      ";"}], "\n", \(par = \[Mu];\), "\n", 
    RowBox[{\(m = 2;\), "\n"}], "\n", \(LindPoinc[sys, unk, var, par, 
      m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {2\ \@\(2/5\)}, {0, 10}, 
      2]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 8.4 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y + \[Mu] \((4\ x - 5\ x\^3 + x\^5 - 5\ x\ y\^2 + 
                      2\ x\^3\ y\^2 + x\ y\^4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) + \[Mu] \((4\ y - 5\ x\^2\ y + x\^4\ y - 
                      5\ y\^3 + 2\ x\^2\ y\^3 + y\^5)\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), 
      ";"}], "\n", \(par = \[Mu];\), "\n", 
    RowBox[{\(m = 1;\), "\n"}], "\n", \(LindPoinc[sys, unk, var, par, 
      m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\(-1\), \(-2\)}, {0, 10}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ y\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}],
       ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), 
      ";"}], "\n", \(par = \[Mu];\), "\n", 
    RowBox[{\(m = 1;\), "\n"}], "\n", \(LindPoinc[sys, unk, var, par, 
      m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {\@3}, {0, 10}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, \(-0.2\), {\@3}, {0, 10}, 1]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ y\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}],
       ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), 
      ";"}], "\n", \(par = \[Mu];\), "\n", 
    RowBox[{\(m = 2;\), "\n"}], "\n", \(LindPoinc[sys, unk, var, par, 
      m]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {\@3}, {0, 10}, 2]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ y\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ x\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}],
       ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", 
      "\n", \(par = \[Mu]\), ";", "\n", 
      "\n", \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.5, 1, 1.5}, {\(-3\), 3}, 
      1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\) \((x\^2 + y\^2 - 
                      2)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ y\ \((x\^2 + y\^2 - 4)\) \((x\^2 + 
                      y\^2 - 2)\)\)}]}], "}"}]}], ";", "\n", \(unk = {x, y}\),
       ";", "\n", \(var = t\), ";", "\n", \(par = \[Mu]\), ";", "\n", 
      "\n", \(LindPoinc[sys, unk, var, par, 2]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\@2, 2}, {0, 40}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], 
              "==", \(y - \[Mu]\ \((x - \(2\ x\)\/\@\(x\^2 + y\^2\) + 
                      x\^2\/\(x\^2 + y\^2\) - \(x\ y\)\/\(x\^2 + \
y\^2\))\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], 
              "==", \(\(-x\) - \[Mu]\ \ \((y - \(2\ y\)\/\@\(x\^2 + y\^2\) + \
\(x\ y\)\/\(x\^2 + y\^2\) - y\^2\/\(x\^2 + y\^2\))\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", 
      "\n", \(par = \[Mu]\), ";", "\n", 
      "\n", \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {2}, {0, 10}, 1]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1130, 861},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->False,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 243, 9, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2179, 72, 62, 1, 91, "Section"],
Cell[2244, 75, 536, 16, 39, "Text"],
Cell[2783, 93, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2928, 101, 158, 3, 91, "Section"],

Cell[CellGroupData[{
Cell[3111, 108, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3229, 113, 314, 8, 141, "Input"],
Cell[3546, 123, 243, 5, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3826, 133, 118, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3947, 138, 314, 8, 141, "Input"],
Cell[4264, 148, 243, 5, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4544, 158, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4661, 163, 334, 9, 141, "Input"],
Cell[4998, 174, 158, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5193, 183, 118, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5314, 188, 334, 9, 141, "Input"],
Cell[5651, 199, 158, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5846, 208, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5963, 213, 352, 10, 162, "Input"],
Cell[6318, 225, 135, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6490, 233, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6607, 238, 352, 10, 162, "Input"],
Cell[6962, 250, 135, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7134, 258, 118, 3, 47, "Subsection",
  Evaluatable->False],
Cell[7255, 263, 352, 10, 162, "Input"],
Cell[7610, 275, 135, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7782, 283, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[7899, 288, 332, 9, 161, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8268, 302, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8385, 307, 331, 9, 196, "Input"],
Cell[8719, 318, 134, 3, 35, "Input"],
Cell[8856, 323, 331, 9, 196, "Input"],
Cell[9190, 334, 134, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9361, 342, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9479, 347, 334, 9, 162, "Input"],
Cell[9816, 358, 153, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10006, 367, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10124, 372, 357, 10, 162, "Input"],
Cell[10484, 384, 152, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10673, 393, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10791, 398, 365, 10, 195, "Input"],
Cell[11159, 410, 155, 4, 35, "Input"],
Cell[11317, 416, 106, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11460, 424, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11578, 429, 721, 18, 162, "Input"],
Cell[12302, 449, 153, 4, 49, "Input"],
Cell[12458, 455, 721, 18, 162, "Input"],
Cell[13182, 475, 152, 4, 49, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13383, 485, 129, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[13537, 491, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13655, 496, 839, 20, 162, "Input"],
Cell[14497, 518, 154, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14688, 527, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14805, 532, 711, 18, 162, "Input"],
Cell[15519, 552, 136, 3, 49, "Input"],
Cell[15658, 557, 143, 4, 49, "Input"],
Cell[15804, 563, 711, 18, 162, "Input"],
Cell[16518, 583, 136, 3, 49, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16691, 591, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16809, 596, 680, 17, 141, "Input"],
Cell[17492, 615, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17684, 624, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17802, 629, 763, 18, 141, "Input"],
Cell[18568, 649, 139, 3, 49, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18744, 657, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[18862, 662, 839, 20, 195, "Input"],
Cell[19704, 684, 135, 3, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

