(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18528,        640]*)
(*NotebookOutlinePosition[     19462,        671]*)
(*  CellTagsIndexPosition[     19418,        667]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 9", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Boundary-Value Problems for Second-Order ODEs",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.3  The Program NBoundary", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' - x\ y' + y\^2 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {1.5, 2};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(eq = \(y'\)' - x\ y' + y\^2 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {1.9, 2.5};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2\ \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 0, y[2\ \[Pi]] == 0};\)\), "\n", 
    \(\({dymin, dymax} = {\(-1\), 1};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2\ \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 0, y[2\ \[Pi]] == 1};\)\), "\n", 
    \(\({dymin, dymax} = {\(-1\), 1};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = Sin[x];\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {\(-4\), \(-3.5\)};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {52, 53};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 1000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 0.01 \( y'\)' + \((x - 0.5)\)\ y' == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == \(-1\)};\)\), "\n", 
    \(\({dymin, dymax} = {\(-1\), 1};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 5000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + x\^2\ y' + Sin[x] - \(x\^2\) Cos[x] == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2  \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 0, 
          y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {\(-1\), 1.5};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(\(ansol = Sin[x];\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"9.5  The Programs NBoundary1 and NBoundary2", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.14 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y' == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2  \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 0, y[2  \[Pi]] == 0};\)\), "\n", 
    \(\(n = 50;\)\), "\n", 
    \(\(ansol = Sin[x];\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.15 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + \(x\^2\) y' + Sin[x] - \(x\^2\) Cos[x] == 
          0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2  \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 0, 
          y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2};\)\), "\n", 
    \(\(n = 200;\)\), "\n", 
    \(\(ansol = Sin[x];\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.16 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + x\ y' - x + x\ Sin[x] + Cos[x] == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2  \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 1, y[2  \[Pi]] == 1 + 2  \[Pi]};\)\), "\n", 
    \(\(n = 300;\)\), "\n", 
    \(\(ansol = x + Cos[x];\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.17 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = 0.01 \( y'\)' + \((x - 0.5)\) y' == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == \(-1\)};\)\), "\n", 
    \(\(n = 300;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.18 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + x\ y\^2 - 100\ x\^3 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\(n = 50;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 20;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)}], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.19 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y' - x\ y\^2 - Cos[x] + Sin[x] + x\ Sin[x]\^2 == 
          0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, \[Pi]/2};\)\), "\n", 
    \(\(data = {y[0] == 0, y[\[Pi]/2] == 1};\)\), "\n", 
    \(\(n = 65;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 20;\)\), "\n", 
    \(\(ansol = Sin[x];\)\), "\n", 
    \(NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)}], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.20 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 1};\)\), "\n", 
    \(\(n = 50;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 50;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)}], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[{
    \(\(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 1};\)\), "\n", 
    \(\({dymin, \ dymax} = {\(-1.12\), \(-1.1\)};\)\), "\n", 
    \(\(n = 20;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 100;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, \ unk, \ var, \ {a, \ b}, \ data, \ {dymin, \ dymax}, \ 
      n, \ steps, \ ansol]\ \)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.21 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + \(y\^2\) y' + 2 \((Cos[x] + Sin[x])\) Sin[x]\^2 == 
          0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2  \[Pi]};\)\), "\n", 
    \(\(data = {y[0] == 1, y[2  \[Pi]] == 1};\)\), "\n", 
    \(\(n = 80;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 20;\)\), "\n", 
    \(\(ansol = Sin[x] + Cos[x];\)\), "\n", 
    \(NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)}], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.6  Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + 10 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 10};\)\), "\n", 
    \(\(data = {y[0] == 1, y[10] == 30};\)\), "\n", 
    \(\({dymin, dymax} = {50, 60};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y' - x\ y == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 2};\)\), "\n", 
    \(\({dymin, dymax} = {0, 2};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + \(x\^2\) \((\ y')\)\^2 == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 0};\)\), "\n", 
    \(\({dymin, dymax} = {\(-2\), 1};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + Sin[x]\ y == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, \[Pi]};\)\), "\n", 
    \(\(\(data = \(data = {y[0] - \(y'\)[0] == 0, 
              y[\[Pi]] == 0.5}\);\);\)\), "\n", 
    \(\({dymin, dymax} = {\(-1\), 0};\)\), "\n", 
    \(\(n = 10;\)\), "\n", 
    \(\(steps = 2000;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, 
      ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + \(x\^2\) y'\^2 - Sin[3  x] == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 0};\)\), "\n", 
    \(\(n = 40;\)\), "\n", 
    \(\(s = 1;\)\), "\n", 
    \(\(steps = 20;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)}], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + \(x\^2\) y - Sin[3\ x] == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 2};\)\), "\n", 
    \(\(data = {y[0] == 1, y[2] == 0};\)\), "\n", 
    \(\(n = 200;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(\(eq = \(y'\)' + y' - x\ y == 0;\)\), "\n", 
    \(\(unk = y;\)\), "\n", 
    \(\(var = x;\)\), "\n", 
    \(\({a, b} = {0, 1};\)\), "\n", 
    \(\(data = {y[0] == 1, y[1] == 0};\)\), "\n", 
    \(\(n = 100;\)\), "\n", 
    \(\(ansol = 0;\)\), "\n", 
    \(NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1127, 874},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 4, 116, "Title",
  Evaluatable->False],
Cell[1911, 59, 267, 10, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2203, 73, 62, 1, 91, "Section"],
Cell[2268, 76, 536, 16, 39, "Text"],
Cell[2807, 94, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2952, 102, 142, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[3119, 108, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[3236, 113, 501, 13, 225, "Input"],
Cell[3740, 128, 503, 13, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4280, 146, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[4397, 151, 507, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4941, 169, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5058, 174, 512, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5607, 192, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[5725, 197, 518, 13, 225, "Input"],
Cell[6246, 212, 508, 13, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6791, 230, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[6909, 235, 520, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7466, 253, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[7584, 258, 581, 14, 225, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8214, 278, 160, 3, 91, "Section"],

Cell[CellGroupData[{
Cell[8399, 285, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[8518, 290, 400, 10, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8955, 305, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9074, 310, 481, 12, 183, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9592, 327, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[9711, 332, 444, 10, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10192, 347, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10311, 352, 407, 10, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10755, 367, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[10874, 372, 469, 13, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11380, 390, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[11499, 395, 523, 14, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12059, 414, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[12178, 419, 470, 13, 225, "Input"],
Cell[12651, 434, 572, 14, 246, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13260, 453, 116, 3, 47, "Subsection",
  Evaluatable->False],
Cell[13379, 458, 536, 14, 225, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13964, 478, 129, 2, 91, "Section"],

Cell[CellGroupData[{
Cell[14118, 484, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14235, 489, 494, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14766, 507, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[14883, 512, 496, 13, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15416, 530, 114, 3, 47, "Subsection",
  Evaluatable->False],
Cell[15533, 535, 514, 13, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16084, 553, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16202, 558, 554, 14, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16793, 577, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[16911, 582, 476, 13, 225, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17424, 600, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[17542, 605, 402, 10, 183, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17981, 620, 115, 3, 47, "Subsection",
  Evaluatable->False],
Cell[18099, 625, 389, 10, 182, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

