(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39419,       1501]
NotebookOptionsPosition[     35119,       1344]
NotebookOutlinePosition[     35880,       1372]
CellTagsIndexPosition[     35837,       1369]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 1", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Solution of ODEs and Their Properties",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.47633037228125*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476330366078125*^9},
 EmphasizeSyntaxErrors->True,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.3  Functions DSolve, NDSolve, and \
DifferentialInvariants", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.4", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", " ", 
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "==", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "+", 
     SuperscriptBox[
      RowBox[{"x", "[", "t", "]"}], "2"], "+", 
     SuperscriptBox["t", "2"]}]}], ",", 
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.5", "Subsection",
 Evaluatable->False,
 CellChangeTimes->{{3.476349667*^9, 3.47634967446875*^9}},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "==", 
      RowBox[{
       FractionBox[
        RowBox[{"x", "[", "t", "]"}], "t"], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "3"]}]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"-", "1"}], "]"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.6", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        SuperscriptBox["x", "\[Prime]",
         MultilineFunction->None], "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "==", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
   
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.5  Applications of the Programs Sysn, Phase2D, \
PolarPhase and Phase3D", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 1.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0.5", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0.5", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0.5", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "15"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"index", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "500"}], ";"}], "\n"}], "\n", 
 RowBox[{"Sysn", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "var", ",", "data", ",", "T1", ",", 
   "index", ",", "steps"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"2", " ", "y"}], 
       RowBox[{"t", "+", "1"}]], "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       FractionBox["t", "3"]}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"2", " ", "x"}], 
       RowBox[{"t", "+", "1"}]], "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       FractionBox["t", "3"]}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "7"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"index", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "3500"}], ";"}], "\n"}], "\n", 
 RowBox[{"Sysn", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "t", ",", "data", ",", "T1", ",", "index", ",", 
   "steps"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.10", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "2000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.11", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "x"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.5", "-", 
        SuperscriptBox["x", "2"]}], ")"}], " ", "y"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.5"}], ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.12", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["r", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["\[CurlyPhi]", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", "1"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"r", ",", "\[CurlyPhi]"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"PolarPhase", "[", 
  RowBox[{"sys", ",", "unk", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.51"}], ",", "4"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.13", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "y"}], "-", "z"}]}]}], ";", "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "==", 
     RowBox[{"x", "+", 
      RowBox[{"0.2", " ", "y"}]}]}]}], ";"}]}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    SuperscriptBox["z", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"0.2", "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2.2"}], ")"}]}]}]}]}], ";", "\n", 
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2", ",", "eq3"}], "}"}]}], ";", "\n", "\n", 
  RowBox[{"Phase3D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "60"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "60"}], "}"}], ",", "20000", ",", "All"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "y"}], "-", "z"}]}]}], ";", "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "==", 
     RowBox[{"x", "+", 
      RowBox[{"0.2", " ", "y"}]}]}]}], ";"}]}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    SuperscriptBox["z", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"0.2", "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2.2"}], ")"}]}]}]}]}], ";", "\n", 
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2", ",", "eq3"}], "}"}]}], ";", "\n", "\n", 
  RowBox[{"Phase3D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "60"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "60"}], "}"}], ",", "20000", ",", "All"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.14", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6"}], " ", "x"}], "-", "y", "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "1.8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "10000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.1"}], ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "2.5"}], "}"}]}], "}"}], ",", "1"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1.3"}], "}"}], ",", "10000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.1"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2.5"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.15", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10"}], " ", "x"}], "+", 
     SuperscriptBox["x", "3"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "10000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}], ",", "2"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.16", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "y"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["x", "2"]}], "+", 
     FractionBox["y", "5"], "-", 
     RowBox[{"x", " ", "y"}], "+", 
     FractionBox[
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"]}], "5"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.6", ",", "0.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "35"}], ",", "5"}], "}"}], ",", "10000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}], ",", "2"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.17", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["x", "4"]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["y", "2"]}], "+", 
     SuperscriptBox["y", "4"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox["x", "3"], " ", "y"}], "-", 
     RowBox[{"10", " ", "x", " ", 
      SuperscriptBox["y", "3"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}], ",", "10000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.5"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.5"}], ",", "4.5"}], "}"}]}], "}"}], ",", "2"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1.18", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"Cos", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["\[Pi]", "2"], ",", 
      FractionBox["\[Pi]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "20"}], "}"}], ",", "1000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "}"}], ",", "3"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1.6 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Yin-yang", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"y", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "x"}], "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], ";", "\n", 
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";", "\n", "\n", 
  RowBox[{"Phase2D", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", "1000", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "2"}], 
   "]"}]}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"y", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "x"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4", ",", "0.4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Prey-predator model", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"x", "-", 
     RowBox[{"x", " ", "y"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "y"}], "+", 
     RowBox[{"x", " ", "y"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2.8"}], "}"}]}], "}"}], ",", "1"}], "]"}]}], "Input",\

 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Exercise ",
 StyleBox["4. Competing species model ",
  FontSize->14]
}], "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"x", "-", 
     RowBox[{"x", " ", "y"}], "-", 
     RowBox[{"0.5", 
      SuperscriptBox["x", "2"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "y"}], "+", 
     RowBox[{"x", " ", "y"}], "-", 
     RowBox[{"0.5", 
      SuperscriptBox["y", "2"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"6", "/", "5"}], ",", 
     RowBox[{"2", "/", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1.5"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}], "\n"}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Pendulum", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", 
     RowBox[{"Sin", "[", "x", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Pendulum with linear friction", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", "y"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"0.1", "y"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["r", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["\[CurlyPhi]", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", "1"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"PolarPhase", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["r", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"2", "-", "r"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["\[CurlyPhi]", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{"-", "2"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"PolarPhase", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "25"}], ",", "0"}], "}"}], ",", "3000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1156, 897},
WindowMargins->{{5, Automatic}, {Automatic, 0}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrintingCopies->1,
PrintingPageRange->{1, 1},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 249, 10, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[995, 43, 61, 1, 87, "Section"],
Cell[1059, 46, 542, 17, 36, "Text"],
Cell[1604, 65, 178, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1819, 75, 174, 3, 87, "Section"],
Cell[CellGroupData[{
Cell[2018, 82, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2132, 87, 493, 16, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2662, 108, 170, 4, 45, "Subsection",
 Evaluatable->False],
Cell[2835, 114, 572, 19, 61, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3444, 138, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3558, 143, 708, 23, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4315, 172, 187, 3, 87, "Section"],
Cell[CellGroupData[{
Cell[4527, 179, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4641, 184, 1287, 44, 234, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5965, 233, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[6079, 238, 1791, 62, 289, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7907, 305, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[8022, 310, 1122, 40, 124, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9181, 355, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[9296, 360, 1282, 46, 127, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10615, 411, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[10730, 416, 1321, 47, 169, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12088, 468, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[12203, 473, 1340, 44, 146, "Input"],
Cell[13546, 519, 1341, 44, 146, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14924, 568, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[15039, 573, 1304, 46, 124, "Input"],
Cell[16346, 621, 734, 26, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17117, 652, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[17232, 657, 1240, 44, 124, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18509, 706, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[18624, 711, 1461, 52, 156, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20122, 768, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[20237, 773, 1510, 52, 126, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21784, 830, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[21899, 835, 1274, 44, 147, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23222, 885, 126, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[23373, 891, 120, 3, 45, "Subsection",
 Evaluatable->False],
Cell[23496, 896, 1461, 50, 133, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24994, 951, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[25108, 956, 1406, 51, 133, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26551, 1012, 131, 3, 45, "Subsection",
 Evaluatable->False],
Cell[26685, 1017, 1176, 42, 124, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27898, 1064, 182, 7, 45, "Subsection",
 Evaluatable->False],
Cell[28083, 1073, 1355, 48, 148, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29475, 1126, 120, 3, 45, "Subsection",
 Evaluatable->False],
Cell[29598, 1131, 1173, 42, 124, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30808, 1178, 141, 3, 45, "Subsection",
 Evaluatable->False],
Cell[30952, 1183, 1223, 44, 124, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32212, 1232, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[32326, 1237, 1279, 45, 152, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33642, 1287, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[33756, 1292, 1323, 47, 147, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
