(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31250,       1162]
NotebookOptionsPosition[     27380,       1019]
NotebookOutlinePosition[     28095,       1045]
CellTagsIndexPosition[     28052,       1042]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 10", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[StyleBox["Rigid Body with a Fixed Point",
 FontSlant->"Italic"]], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.47678546646875*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769372921875*^9},
 EmphasizeSyntaxErrors->True,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.6 The Program Poinsot", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 10.1 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.2 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "2"}]}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.3 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", "0.05"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "4"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "20"}]}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.4 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"-", "0.1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "30"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "\[Pi]"}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 10.7 The Program Solid", "Section",
 FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Example 10.5",
 FontFamily->"Times New Roman"]], "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.6", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "5000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "0.9"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "0.8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 10.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "0.8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["10.8 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "2"}]}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "20"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "10"}]}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "20"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Pi]", "/", "15"}]}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "20"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "\[Pi]"}], ";"}], "\n", 
 RowBox[{"Poinsot", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", " ", "r0", ",", " ", "\[Theta]0", 
   ",", " ", "T", ",", " ", "\[Alpha]", ",", "1000"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Exercise 6.",
 StyleBox[" ",
  FontWeight->"Plain"]
}], "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[CurlyPhi]", "[", "t", "]"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "4"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "40"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[CurlyPhi]", "[", "t", "]"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "3000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", "0.8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"C0", "=", "1.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]", ",", "\[CurlyPhi]", ",", "\[Theta]", ",", "t"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[CurlyPhi]", "[", "t", "]"}], "]"}], ",", " ", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q0", "=", "0.2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r0", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]0", "=", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"\[Pi]", "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "5000"}], ";"}], "\n", 
 RowBox[{"Solid", "[", 
  RowBox[{
  "A", ",", " ", "B", ",", " ", "C0", ",", "va", ",", "z", ",", "F", ",", 
   "p0", ",", "q0", ",", "r0", ",", "\[Psi]0", ",", "\[CurlyPhi]0", ",", " ", 
   "\[Theta]0", ",", " ", "T", ",", "steps"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1271, 858},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 129, 4, 102, "Title",
 Evaluatable->False],
Cell[722, 29, 229, 7, 61, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[976, 40, 61, 1, 87, "Section"],
Cell[1040, 43, 542, 17, 36, "Text"],
Cell[1585, 62, 178, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1800, 72, 139, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[1964, 78, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2080, 83, 742, 24, 212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2859, 112, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2975, 117, 681, 22, 190, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3693, 144, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3809, 149, 659, 21, 190, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4505, 175, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4621, 180, 653, 21, 190, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5323, 207, 105, 1, 87, "Section"],
Cell[CellGroupData[{
Cell[5453, 212, 132, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5588, 217, 1331, 44, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6956, 266, 80, 2, 46, "Subsection",
 Evaluatable->False],
Cell[7039, 270, 1332, 44, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8408, 319, 80, 2, 46, "Subsection",
 Evaluatable->False],
Cell[8491, 323, 1333, 44, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9861, 372, 80, 2, 46, "Subsection",
 Evaluatable->False],
Cell[9944, 376, 1333, 44, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11314, 425, 80, 2, 46, "Subsection",
 Evaluatable->False],
Cell[11397, 429, 1482, 49, 344, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12928, 484, 95, 1, 87, "Section"],
Cell[CellGroupData[{
Cell[13048, 489, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[13162, 494, 679, 22, 190, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13878, 521, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[13993, 526, 701, 23, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14731, 554, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14845, 559, 701, 23, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15583, 587, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15697, 592, 676, 22, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16410, 619, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[16524, 624, 1381, 46, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17942, 675, 165, 7, 45, "Subsection",
 Evaluatable->False],
Cell[18110, 684, 1380, 46, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19527, 735, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[19641, 740, 1333, 44, 344, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21011, 789, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21125, 794, 1457, 48, 329, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22619, 847, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[22733, 852, 1382, 46, 329, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24152, 903, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[24267, 908, 1457, 48, 329, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25761, 961, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[25876, 966, 1464, 48, 329, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
