(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44663,       1715]
NotebookOptionsPosition[     40168,       1551]
NotebookOutlinePosition[     40874,       1577]
CellTagsIndexPosition[     40831,       1574]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 2", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Linear ODEs with Constant Coefficients ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"]
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476784663484375*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769443078125*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.2  The General Solution of Linear Differential \
Systems with Constant Coefficients", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.1", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "==", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["5", "4"]}], 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], "/", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.3 The Program LinSys", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.2: Asymptotically stable focus", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\n", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";", "\n", 
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";", "\n", 
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "y0"}], "}"}]}], ";", "\n", 
  RowBox[{"eq1", "=", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "x"}], "+", "y"}]}]}], ";", "\n", 
  RowBox[{"eq2", "=", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "==", 
    RowBox[{
     RowBox[{"-", "x"}], "-", "y"}]}]}], ";", "\n", 
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";", "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "16"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.3: Asymptotically stable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"unk", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"unk0", "=", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq2", "=", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "3"}], " ", "y"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"sys", "=", 
     RowBox[{"{", 
      RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], " ", "\n", "\n", 
   RowBox[{"LinSys", "[", 
    RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], " "}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.4: Asymptotically stable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", " ", 
     RowBox[{"-", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.5: Asymptotically stable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x"}], "-", 
      RowBox[{"3", " ", "y"}]}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"-", " ", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.6:  Neutrally stable center", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", "y"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"-", "x"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.3"}], ",", "2.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.3"}], ",", "2.3"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.7:  Unstable saddlepoint", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"x", "+", 
      RowBox[{"4", "y"}]}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"x", "+", " ", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.8:  Unstable focus", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"x", "-", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"x", "+", " ", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.9:  Unstable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"unk", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"unk0", "=", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"2", "x"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq2", "=", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"2", " ", "y"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"sys", "=", 
     RowBox[{"{", 
      RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], " ", "\n", "\n", 
   RowBox[{"LinSys", "[", 
    RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], " "}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.10:  Unstable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", " ", "y"}]}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", "y"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.4  Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Unstable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"x", "+", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", " ", "y"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. Stable focus", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", "y"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{
      RowBox[{"-", "x"}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "y"}]}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "60"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Stable node", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "5"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"-", "x"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{
      RowBox[{"-", "5"}], " ", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. Neutrally stable center", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"2", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"-", "x"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.1"}], ",", "2.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Unstable saddlepoint", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{"x", "'"}], "==", 
     RowBox[{"-", "x"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"y", "'"}], "==", 
     RowBox[{"5", " ", "y"}]}]}], ";"}], "\n", 
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "\n", 
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "1000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Forced vibration", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"LinSys", "[", 
   RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}], "  "}]}], "Input",\

 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. Forced vibration", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "t"}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Tan", "[", "t", "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "t", "]"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "t"}], "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], "/", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"t", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "t"}], "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0", ",", "z0"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"x01", ",", "x02", ",", "x03", ",", "x04"}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"LinSys", "[", 
  RowBox[{"A", ",", "b", ",", "unk", ",", "unk0"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{693, 436},
WindowMargins->{{9, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 284, 11, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1030, 44, 61, 1, 87, "Section"],
Cell[1094, 47, 543, 17, 58, "Text"],
Cell[1640, 66, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1825, 75, 199, 3, 119, "Section"],
Cell[CellGroupData[{
Cell[2049, 82, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2163, 87, 756, 25, 61, "Input"],
Cell[2922, 114, 766, 28, 146, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3737, 148, 136, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[3898, 154, 140, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4041, 159, 1772, 61, 256, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5850, 225, 139, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5992, 230, 1848, 66, 256, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7877, 301, 139, 3, 57, "Subsection",
 Evaluatable->False],
Cell[8019, 306, 1763, 64, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9819, 375, 139, 3, 57, "Subsection",
 Evaluatable->False],
Cell[9961, 380, 1842, 67, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11840, 452, 137, 3, 57, "Subsection",
 Evaluatable->False],
Cell[11980, 457, 1692, 61, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13709, 523, 134, 3, 57, "Subsection",
 Evaluatable->False],
Cell[13846, 528, 1720, 62, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15603, 595, 128, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15734, 600, 1720, 62, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17491, 667, 127, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17621, 672, 1747, 62, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19405, 739, 128, 3, 57, "Subsection",
 Evaluatable->False],
Cell[19536, 744, 1721, 62, 224, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21306, 812, 127, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[21458, 818, 125, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21586, 823, 1697, 61, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23320, 889, 124, 3, 57, "Subsection",
 Evaluatable->False],
Cell[23447, 894, 1891, 69, 302, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25375, 968, 123, 3, 57, "Subsection",
 Evaluatable->False],
Cell[25501, 973, 1783, 65, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27321, 1043, 135, 3, 57, "Subsection",
 Evaluatable->False],
Cell[27459, 1048, 1738, 63, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29234, 1116, 132, 3, 57, "Subsection",
 Evaluatable->False],
Cell[29369, 1121, 1737, 63, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31143, 1189, 128, 3, 57, "Subsection",
 Evaluatable->False],
Cell[31274, 1194, 817, 31, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32128, 1230, 128, 3, 57, "Subsection",
 Evaluatable->False],
Cell[32259, 1235, 794, 29, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33090, 1269, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[33204, 1274, 772, 28, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34013, 1307, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[34127, 1312, 818, 30, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34982, 1347, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[35097, 1352, 822, 30, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35956, 1387, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[36071, 1392, 772, 28, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36880, 1425, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[36995, 1430, 814, 30, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37846, 1465, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[37961, 1470, 923, 31, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38921, 1506, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[39036, 1511, 1092, 35, 140, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
