(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36070,       1390]
NotebookOptionsPosition[     30866,       1200]
NotebookOutlinePosition[     31574,       1226]
CellTagsIndexPosition[     31531,       1223]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 3", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Power Series Solution of ODEs \nand Frobenius Series",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476784684375*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769456078125*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.2  Power Series and the Program Taylor", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Examples relative to the built-in functions Series and Normal\
\>", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "7"}], "}"}]}], "]"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example relative to the program Taylor", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Taylor", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "7"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.5 The Program SerSol", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Example 3.3: Material point subjected to an undamped and aging spring\
\>", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "0.1"}], " ", "t"}], "]"}]}], " ", "x"}]}]}], "}"}]}],
    ";"}],
  FontSize->12], "\n", 
 StyleBox[
  RowBox[{"SerSol", "[", 
   RowBox[{"sys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", "4", ",", "0", ",", "2", ",", 
    "2000"}], "]"}],
  FontSize->12]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 3.4:  Material point subjected to its weight and a resistence\
\>", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", "u"}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", "w"}], ",", 
     RowBox[{
      SuperscriptBox["u", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "0.0001"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["u", "2"], "+", 
         SuperscriptBox["w", "2"]}]], "u"}]}], ",", 
     RowBox[{
      SuperscriptBox["w", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "10"}], "-", 
       RowBox[{"0.0001", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["u", "2"], "+", 
          SuperscriptBox["w", "2"]}]], "w"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "u", ",", "w"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk0", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"100", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"45", " ", "Degree"}], "]"}]}], ",", 
      RowBox[{"100", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"45", " ", "Degree"}], "]"}]}]}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "t", ",", "unk0", ",", "4", ",", "0", ",", "14", 
   ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.6 Other Applications of SerSol", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.5: Airy's equation", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{"-", "t"}], " ", "x"}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", "6", ",", "0", ",", "2", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.6: Mathieu's equation", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}], " ", "x"}]}]}], "}"}]}],
    ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", "4", ",", "0", ",", "2", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["x", "\[Prime]\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["x", "2"]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", "x", "}"}], ",", "t", ",", 
   RowBox[{"{", "0", "}"}], ",", "11", ",", "0", ",", "1.9", ",", "2000"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.8: Hermite's equation", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{"2", " ", "t", " ", "y"}], "-", 
        RowBox[{"6", "x"}]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "12"}]}], "}"}], ",", "4", ",", "0", ",", "4", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.7 The Program Frobenius", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"x", " "}], "2"], 
      SuperscriptBox["y", "\[Prime]\[Prime]",
       MultilineFunction->None]}], "-", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None]}], "+", 
     RowBox[{"x", " ", "y"}]}], " ", "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"var", "=", "x"}], ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", "3", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[" "], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.10", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"x", " "}], "2"], 
      RowBox[{
       RowBox[{"y", "'"}], "'"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"y", "'"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "3"]}], ")"}], "y"}]}], " ", "==", "0"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"var", "=", "x"}], ";"}], "\n"}], "\n", 
 StyleBox[
  RowBox[{"Frobenius", "[", 
   RowBox[{"eq", ",", "unk", ",", "var", ",", "5", ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "0.5", "]"}], "==", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0.5", "]"}], "==", "0.5"}]}], "}"}], ",", 
    "1000"}], "]"}],
  FontSize->12]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.11", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", " "}], "2"], 
       RowBox[{
        RowBox[{"y", "'"}], "'"}]}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"y", "'"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "y"}]}], " ", "==", "0"}]}], 
   ";"}],
  FontSize->12], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"unk", "=", "y"}], ";"}],
  FontSize->12], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"var", "=", "x"}], ";"}],
   FontSize->12], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0.5", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0.5", "]"}], "==", "0.5"}]}], "}"}], ",", 
   "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.12", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Frobenius", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "\[Prime]",
       MultilineFunction->None]}], "+", 
     RowBox[{
      FractionBox[
       RowBox[{"x", " "}], "2"], 
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None]}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}], " ", "x", " ", "y"}]}], "==",
     "0"}], ",", "y", ",", "x", ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0.2", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "0.2", "]"}], "==", "0.5"}]}], "}"}], 
   ",", "1000"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.8 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "x"}], "+", 
        RowBox[{"t", " ", 
         RowBox[{"Cos", "[", "t", "]"}]}]}]}]}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "6", ",", "0", ",", "1.5", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{"x", "-", "y", "+", "2"}]}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{"y", "-", " ", "x", "+", "t"}]}]}], " ", "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "6", ",", "0", ",", "2", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{"y", "+", 
        RowBox[{"Exp", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{"x", "+", 
        RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "5", ",", "0", ",", "2", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", "y"}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", "z"}], ",", 
      RowBox[{
       SuperscriptBox["z", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", "x"}], "-", 
        RowBox[{"11", " ", "y"}], "-", 
        RowBox[{"6", " ", "z"}], "+", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "t"}], "]"}]}]}]}], " ", "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "20", ",", "0", ",", "2", 
   ",", "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "==", 
       RowBox[{"-", 
        RowBox[{"Sin", "[", "y", "]"}]}]}], ",", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "==", 
       SuperscriptBox["x", "2"]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"SerSol", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0.5"}], "}"}], ",", "4", ",", "0", ",", "1", ",", 
   "2000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      SuperscriptBox["y", "\[Prime]\[Prime]",
       MultilineFunction->None]}], "-", 
     RowBox[{
      SuperscriptBox["x", "3"], "y"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"var", "=", "x"}], ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", "6", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"x", " "}], "2"], 
      RowBox[{
       RowBox[{"y", "'"}], "'"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"y", "'"}]}], "+", 
     RowBox[{"3", 
      SuperscriptBox["x", "2"], " ", "y"}]}], " ", "==", "0"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"var", "=", "x"}], ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0.5", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0.5", "]"}], "==", "0.5"}]}], "}"}], ",", 
   "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "\[Prime]",
       MultilineFunction->None]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "8"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], " ", "y"}]}], "==", "0"}]}], 
  ";"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "8", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", " "}], "2"], 
       RowBox[{
        RowBox[{"y", "'"}], "'"}]}], "+", 
      RowBox[{"x", "  ", 
       RowBox[{"y", "'"}]}], "+", 
      RowBox[{"2", "x", " ", "y"}]}], " ", "==", "0"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "6", ",", 
   RowBox[{"{", 
    RowBox[{"0.3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0.3", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0.3", "]"}], "==", "1"}]}], "}"}], ",", 
   "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", " "}], "2"], 
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None]}], "-", 
      RowBox[{"x", "  ", "y"}]}], " ", "==", "0"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "5", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], 
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{"x", " ", 
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0.5", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0.5", "]"}], "==", "3"}]}], "}"}], ",", 
   "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], 
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "3", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], 
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{"x", "  ", 
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}], "y"}]}], "==", "0"}]}], 
   ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "3", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", "  ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], 
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{"x", "  ", 
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "4"}], ")"}], "y"}]}], "==", "0"}]}], 
   ";"}], "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "4", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox[
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "\[Prime]",
        MultilineFunction->None]}], "+", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None]}], "2"], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "x", " ", 
       RowBox[{"Cos", "[", "x", "]"}], " ", "y"}]}], "==", "0"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"Frobenius", "[", 
  RowBox[{"eq", ",", "y", ",", "x", ",", "4", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", "1000"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{674, 498},
WindowMargins->{{25, Automatic}, {Automatic, -4}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 249, 9, 98, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[995, 42, 61, 1, 87, "Section"],
Cell[1059, 45, 540, 17, 58, "Text"],
Cell[1602, 64, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1787, 73, 154, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[1966, 79, 169, 5, 45, "Subsection",
 Evaluatable->False],
Cell[2138, 86, 244, 8, 35, "Input"],
Cell[2385, 96, 338, 11, 35, "Input"],
Cell[2726, 109, 378, 12, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3141, 126, 138, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3282, 131, 328, 11, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3659, 148, 136, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[3820, 154, 177, 5, 67, "Subsection",
 Evaluatable->False],
Cell[4000, 161, 915, 32, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4952, 198, 177, 5, 45, "Subsection",
 Evaluatable->False],
Cell[5132, 205, 1559, 52, 184, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6740, 263, 146, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[6911, 269, 128, 3, 57, "Subsection",
 Evaluatable->False],
Cell[7042, 274, 693, 23, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7772, 302, 131, 3, 57, "Subsection",
 Evaluatable->False],
Cell[7906, 307, 797, 27, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8740, 339, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[8854, 344, 560, 18, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9451, 367, 132, 3, 57, "Subsection",
 Evaluatable->False],
Cell[9586, 372, 754, 25, 77, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10389, 403, 139, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[10553, 409, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[10667, 414, 780, 26, 119, "Input"],
Cell[11450, 442, 27, 0, 34, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11514, 447, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[11629, 452, 1085, 40, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12751, 497, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[12867, 502, 1184, 45, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14088, 552, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14203, 557, 1060, 35, 85, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15312, 598, 126, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[15463, 604, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15577, 609, 794, 27, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16408, 641, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[16522, 646, 730, 24, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17289, 675, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17403, 680, 769, 25, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18209, 710, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[18323, 715, 996, 31, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19356, 751, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[19470, 756, 731, 24, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20238, 785, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[20352, 790, 672, 23, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21061, 818, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21175, 823, 939, 34, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22151, 862, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[22265, 867, 684, 23, 81, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22986, 895, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[23100, 900, 809, 29, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23946, 934, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[24061, 939, 560, 18, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24658, 962, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[24773, 967, 823, 28, 77, "Input"],
Cell[25599, 997, 493, 17, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26129, 1019, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[26244, 1024, 641, 21, 77, "Input"],
Cell[26888, 1047, 521, 18, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27446, 1070, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[27561, 1075, 724, 24, 77, "Input"],
Cell[28288, 1101, 601, 21, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28926, 1127, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[29041, 1132, 817, 27, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29895, 1164, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[30010, 1169, 816, 26, 104, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
