(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21212,        812]
NotebookOptionsPosition[     18657,        717]
NotebookOutlinePosition[     19372,        743]
CellTagsIndexPosition[     19329,        740]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 4", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Poincar\[EAcute]'s Perturbation Method",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.4767847044375*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769466046875*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4.4 The Program Poincare", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 4.4", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", " ", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", " ", 
          SuperscriptBox["x", "2"]}], ")"}], " ", "y"}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"pref", "=", "frac"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", " ", "pref"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.5", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", " ", "y"}], "+", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["y", "2"]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"x", "+", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["x", "2"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"pref", "=", "frac"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", " ", "pref"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.6", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        SuperscriptBox["y", "2"]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", "x"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"pref", "=", "frac"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "pref"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "10"}], "x"}], "+", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["x", "3"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"y", "+", 
       RowBox[{"\[Mu]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["y", "3"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "5000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"y", "+", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"], "-", "1"}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"], "-", "1"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "15"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4.5 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "u"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", "v"}], ",", 
     RowBox[{
      RowBox[{"z", "'"}], "==", "w"}], ",", 
     RowBox[{
      RowBox[{"u", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"(", 
        RowBox[{"w", "-", "v"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"v", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", "u"}]}], ",", 
     RowBox[{
      RowBox[{"w", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"\[Mu]", " ", "u"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "u", ",", "v", ",", "w"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.002"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "y"}], "-", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"], "+", "1"}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"x", "-", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"], "+", "1"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "14"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["x", "3"]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["y", "3"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"2", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "y"}], "-", 
       RowBox[{"\[Mu]", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "y"}], "]"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk0", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T1", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"T2", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"steps", "=", "2000"}], ";"}], "\n"}], "\n", 
 RowBox[{"Poincare", "[", 
  RowBox[{
  "sys", ",", "unk", ",", "var", ",", "unk0", ",", "par", ",", "m", ",", "r", 
   ",", "T1", ",", "T2", ",", "steps", ",", "frac"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{737, 422},
WindowMargins->{{4, Automatic}, {Automatic, 10}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 250, 10, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[996, 43, 61, 1, 87, "Section"],
Cell[1060, 46, 541, 17, 58, "Text"],
Cell[1604, 65, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1789, 74, 138, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[1952, 80, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2067, 85, 1335, 47, 305, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3439, 137, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3554, 142, 1345, 47, 305, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4936, 194, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5051, 199, 1255, 44, 305, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6343, 248, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[6458, 253, 1214, 43, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7709, 301, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[7824, 306, 1397, 49, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9258, 360, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[9373, 365, 1507, 52, 266, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10929, 423, 126, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[11080, 429, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[11194, 434, 1647, 57, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12878, 496, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[12992, 501, 1507, 52, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14536, 558, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14650, 563, 1141, 40, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15828, 608, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15942, 613, 1277, 45, 266, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17256, 663, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17370, 668, 1247, 44, 266, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
