(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25580,       1021]
NotebookOptionsPosition[     21940,        888]
NotebookOutlinePosition[     22654,        914]
CellTagsIndexPosition[     22611,        911]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 5", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Problems of Stability",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476784770140625*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769475578125*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.5 The Program Liapunov", "Section",
 FontFamily->"Times New Roman"]], "Section",
 TextAlignment->Left,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.3", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{"y", "+", 
        RowBox[{"x", " ", 
         SuperscriptBox["y", "4"]}], "-", 
        RowBox[{"2", 
         SuperscriptBox["x", "3"]}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "3"]}], "-", 
        SuperscriptBox["y", "7"]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Liapunov", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "1", ",", "1", ",", "50"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.4 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{"-", " ", "y"}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "x"}], "-", 
        RowBox[{"2", " ", "y"}], "-", 
        SuperscriptBox["y", "3"]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Liapunov", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", "0.6", ",", "0.75", ",", 
   "50"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.5 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "x"}], "+", " ", "y"}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "x"}], "-", "y", "-", 
        SuperscriptBox["x", "3"]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Liapunov", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", "1.4", ",", "1", ",", "50"}],
   "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.6 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{"-", " ", "x"}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "y"}], "+", 
        SuperscriptBox["y", "2"]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Liapunov", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "0.5", ",", "0.75", ",", 
   "50"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "y"}], "-", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{"x", "-", 
        RowBox[{"y", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"Liapunov", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "1", ",", "1", ",", "50"}], 
  "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.7 The Program LStability", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"2", " ", "x", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"1", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       SuperscriptBox["y", "2"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         SqrtBox["3"]}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", 
         SqrtBox["3"]}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.9 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.10", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"x", "+", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"2", " ", "x", " ", "y"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.8 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], "+", "y"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", "y"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "-", "y"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], "-", "y", "-", 
       SuperscriptBox["x", "3"]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"x", "-", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", "y", "-", 
       SuperscriptBox["x", "3"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "-", 
          SuperscriptBox["x", "2"]}], ")"}], "y"}]}], "==", "0"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "-", 
          SuperscriptBox["x", "2"]}], ")"}], "y"}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}], "-", "y", "-", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"x", "-", "y", "+", 
       RowBox[{"y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "-", 
         RowBox[{"3", " ", "y"}]}], "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"1", "-", "x", "-", 
       RowBox[{"Cos", "[", "y", "]"}]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "-", 
         RowBox[{"3", " ", "y"}]}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"1", "-", "x", "-", 
       RowBox[{"Cos", "[", "y", "]"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", 
         RowBox[{"ArcCos", "[", "2", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"ArcCos", "[", "2", "]"}]}], "}"}]}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "y"}], ")"}], "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", "x"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"y", "-", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "x"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "y"}], "+", 
       SuperscriptBox["y", "3"]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"-", "x"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "y"}], "+", 
       SuperscriptBox["y", "3"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{"-", "x"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xe", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"LStability", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "xe"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{719, 362},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 233, 10, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[979, 43, 61, 1, 87, "Section"],
Cell[1043, 46, 543, 17, 58, "Text"],
Cell[1589, 65, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1774, 74, 160, 3, 87, "Section"],
Cell[CellGroupData[{
Cell[1959, 81, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2074, 86, 1076, 37, 88, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3187, 128, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3303, 133, 880, 31, 88, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4220, 169, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4336, 174, 911, 32, 88, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5284, 211, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5400, 216, 841, 30, 88, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6278, 251, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[6393, 256, 1120, 40, 88, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7562, 302, 140, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[7727, 308, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[7842, 313, 1091, 39, 128, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8970, 357, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[9086, 362, 851, 31, 102, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9974, 398, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[10090, 403, 636, 23, 102, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10775, 432, 126, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[10926, 438, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[11041, 443, 443, 16, 35, "Input"],
Cell[11487, 461, 851, 31, 102, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12375, 497, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[12489, 502, 672, 25, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13198, 532, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[13312, 537, 421, 15, 35, "Input"],
Cell[13736, 554, 688, 25, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14461, 584, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14575, 589, 502, 19, 57, "Input"],
Cell[15080, 610, 768, 29, 123, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15885, 644, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15999, 649, 1000, 35, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17036, 689, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17150, 694, 550, 19, 35, "Input"],
Cell[17703, 715, 1119, 40, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18859, 760, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[18973, 765, 777, 28, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19787, 798, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[19901, 803, 406, 15, 35, "Input"],
Cell[20310, 820, 845, 31, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21192, 856, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21306, 861, 594, 22, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
