(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30849,       1192]
NotebookOptionsPosition[     27024,       1054]
NotebookOutlinePosition[     27800,       1082]
CellTagsIndexPosition[     27757,       1079]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 6", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Stability: The Critical Case",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.4767848005*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.4767694930625*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.3 The Programs CriticalEqS and CriticalEqN", \
"Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.1", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "v"}], "-", 
       RowBox[{"a", " ", "\[Lambda]", " ", 
        SuperscriptBox["v", "2"]}], "-", 
       RowBox[{
        FractionBox["1", "3"], "a", " ", 
        SuperscriptBox["v", "3"]}]}]}], ",", 
     RowBox[{
      RowBox[{"v", "'"}], "==", 
      RowBox[{"u", "-", 
       RowBox[{"\[Lambda]", " ", 
        SuperscriptBox["v", "2"]}], "-", 
       RowBox[{
        FractionBox["1", "3"], 
        SuperscriptBox["v", "3"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"order", "=", "10"}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", "unk", ",", "order"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "v"}], "-", 
       FractionBox[
        SuperscriptBox["v", "3"], 
        RowBox[{"6", " ", 
         SuperscriptBox["\[Lambda]", "2"]}]], "-", 
       FractionBox[
        SuperscriptBox["v", "2"], 
        RowBox[{"2", " ", "\[Lambda]"}]]}]}], ",", 
     RowBox[{
      RowBox[{"v", "'"}], "==", 
      RowBox[{"u", "-", 
       FractionBox[
        SuperscriptBox["v", "3"], "3"], "-", 
       RowBox[{
        SuperscriptBox["v", "2"], " ", "\[Lambda]"}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"order", "=", "10"}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", "unk", ",", "order"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.2", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"x", "+", "y", "+", 
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], "y"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}], "-", "y", "-", 
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", "x", " ", "y"}], "-", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", "y"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqN", "[", 
  RowBox[{"sys", ",", "unk"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.002", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "800"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.006"}], ",", "0.006"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.008"}], ",", "0.008"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.3", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "y"}], "-", 
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], ")"}], "3"]}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"3", " ", "x"}], "-", 
        RowBox[{"y", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], ")"}], "3"]}]}]}]}], "}"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "10"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02", ",", "0.02"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "80"}], ",", "120"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06"}], ",", "0.06"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06"}], ",", "0.06"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "100"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.002", ",", "0.002"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "200"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.006"}], ",", "0.006"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.006"}], ",", "0.006"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.4", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{"-", " ", "y"}], "+", 
        RowBox[{"0.1", " ", "x", " ", 
         SuperscriptBox["y", "2"]}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{"x", "-", 
        RowBox[{"0.1", " ", "y", " ", 
         SuperscriptBox["x", "2"]}]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqN", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{"-", " ", "y"}], "+", 
        RowBox[{
         FractionBox[
          RowBox[{"1", " "}], "10"], " ", "x", " ", 
         SuperscriptBox["y", "2"]}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{"x", "-", 
        RowBox[{
         FractionBox[
          RowBox[{"1", " "}], "10"], " ", "y", " ", 
         SuperscriptBox["x", "2"]}]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "20"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "120"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.5", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sys", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "==", "y"}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "x"}], "-", " ", 
        SuperscriptBox["x", "3"]}]}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "20"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Phase2D", "[", 
  RowBox[{"sys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "20"}], "}"}], ",", "5000", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.4"}], ",", "1.4"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.5 The Program CManifold", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", "y"}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "x"}], "-", 
         RowBox[{"x", " ", "z"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "-", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "2"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         SuperscriptBox["x", "2"], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["y", "2"]}], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "+", 
        RowBox[{
         SuperscriptBox["x", "2"], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         RowBox[{"\[Epsilon]", " ", "x"}], "-", 
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"x", " ", "y"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Epsilon]", "'"}], "==", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "y"}], "+", 
        SuperscriptBox["y", "2"], "-", 
        SuperscriptBox["x", "2"]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "\[Epsilon]"}], "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.6 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{"-", 
        SuperscriptBox["x", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "y"}], "+", 
        SuperscriptBox["x", "2"]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "4"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "y"}], "-", 
         RowBox[{
          SuperscriptBox["x", "2"], 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"], "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"z", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"], "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "'"}], "==", 
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{"-", "y"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Lambda]", "'"}], "==", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"\[Lambda]", " ", "x"}], "-", "y"}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "\[Lambda]"}], "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "y"}], "+", 
         RowBox[{"x", " ", "y"}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{"x", "-", 
         RowBox[{"x", " ", 
          SuperscriptBox["y", "2"]}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "+", 
        RowBox[{"x", " ", 
         SuperscriptBox["z", "2"]}]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "4"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         RowBox[{"\[Mu]", " ", "x"}], "+", "y"}]}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "x"}], "+", 
         RowBox[{"\[Mu]", " ", "x"}], "-", 
         RowBox[{"x", " ", "z"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Mu]", "'"}], "==", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "-", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Mu]"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Lambda]", "'"}], "==", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "'"}], "==", 
       RowBox[{
        RowBox[{"\[Lambda]", " ", "x"}], "-", "y"}]}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "\[Lambda]"}], "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "y"}], "+", 
         RowBox[{"x", " ", "y"}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{"x", "-", 
         RowBox[{"x", " ", 
          SuperscriptBox["y", "2"]}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "+", 
        RowBox[{"x", " ", 
         SuperscriptBox["z", "2"]}]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "4"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "==", 
        RowBox[{
         RowBox[{"\[Mu]", " ", "x"}], "+", "y"}]}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "==", 
        RowBox[{
         RowBox[{"-", "x"}], "+", 
         RowBox[{"\[Mu]", " ", "y"}], "-", 
         RowBox[{"x", " ", "z"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Mu]", "'"}], "==", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z", "'"}], "==", 
       RowBox[{
        RowBox[{"-", "z"}], "+", 
        SuperscriptBox["x", "2"]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Mu]"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"CManifold", "[", 
  RowBox[{"sys", ",", "unk", ",", "3"}], "]"}]}], "Input",
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{713, 391},
WindowMargins->{{8, Automatic}, {Automatic, 7}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 225, 9, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[971, 42, 61, 1, 87, "Section"],
Cell[1035, 45, 538, 17, 58, "Text"],
Cell[1576, 64, 146, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1759, 73, 160, 3, 87, "Section"],
Cell[CellGroupData[{
Cell[1944, 80, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2059, 85, 966, 33, 151, "Input"],
Cell[3028, 120, 996, 35, 158, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4061, 160, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4176, 165, 900, 30, 107, "Input"],
Cell[5079, 197, 701, 24, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5817, 226, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5932, 231, 968, 34, 86, "Input"],
Cell[6903, 267, 721, 25, 58, "Input"],
Cell[7627, 294, 694, 24, 58, "Input"],
Cell[8324, 320, 705, 24, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9066, 349, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[9181, 354, 667, 23, 85, "Input"],
Cell[9851, 379, 784, 27, 102, "Input"],
Cell[10638, 408, 685, 24, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11360, 437, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[11475, 442, 536, 19, 77, "Input"],
Cell[12014, 463, 692, 24, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12755, 493, 139, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[12919, 499, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[13034, 504, 913, 33, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13984, 542, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14099, 547, 1473, 51, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15609, 603, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15724, 608, 996, 34, 98, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16769, 648, 126, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[16920, 654, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17034, 659, 742, 27, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17813, 691, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17927, 696, 1535, 53, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19499, 754, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[19613, 759, 683, 25, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20333, 789, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[20447, 794, 801, 29, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21285, 828, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21399, 833, 1004, 36, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22440, 874, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[22554, 879, 1101, 38, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23692, 922, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[23806, 927, 801, 29, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24644, 961, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[24758, 966, 1004, 36, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25799, 1007, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[25913, 1012, 1071, 37, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
