(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39998,       1554]
NotebookOptionsPosition[     33579,       1328]
NotebookOutlinePosition[     34295,       1354]
CellTagsIndexPosition[     34252,       1351]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 7", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Bifurcation in ODEs",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476784819203125*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.47676950496875*^9},
 EmphasizeSyntaxErrors->True,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.3 The Programs Bif1 and Bif1G", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.1", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"u", "'"}], "==", 
    RowBox[{"\[Alpha]", "+", "u"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "u"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Alpha]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{"Bif1G", "[", 
   RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
   "]"}]}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.2", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"u", "'"}], "==", 
    RowBox[{"\[Alpha]", "-", 
     SuperscriptBox["u", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "u"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Alpha]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.3", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Lambda]", " ", "x"}], "-", 
       SuperscriptBox["x", "3"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Lambda]", "+", "2"}], ")"}], "+", 
       SuperscriptBox["x", "2"], "+", "1"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.4", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "+", "x", "-", 
       SuperscriptBox["x", "3"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SuperscriptBox["x", "2"], "-", "1"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.4 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"u", "'"}], "==", 
    RowBox[{"\[Alpha]", "+", 
     SuperscriptBox["u", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "u"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Alpha]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"u", "'"}], "==", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"\[Alpha]", " ", 
      SuperscriptBox["u", "2"]}], "+", 
     SuperscriptBox["u", "3"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "u"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Alpha]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "-", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", 
     SuperscriptBox["x", "4"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"\[Mu]", "  ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"]]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "-", 
     FractionBox["x", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "\[Lambda]"}], "-", "x", "+", "1"}], ")"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[Lambda]"}], "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "20"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif1", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif1G", "[", 
  RowBox[{"eq", ",", "unk", ",", "par", ",", "1", ",", "0.5", ",", "50"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.6 The Programs Bif2 and Bif2G", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.5 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", 
     RowBox[{"\[Mu]", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.02"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.6", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", 
     RowBox[{"\[Mu]", " ", "x"}], "-", 
     SuperscriptBox["x", "3"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[" "], "Input"],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.02"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.7 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", 
     RowBox[{"\[Mu]", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"\[Lambda]", " ", 
      SuperscriptBox["x", "4"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.02"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", "\[Lambda]"}], ")"}], " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.02"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     SuperscriptBox["\[Lambda]", "2"], "+", 
     RowBox[{"2", " ", "\[Mu]", " ", "\[Lambda]", " ", "x"}], "+", "\[Mu]", 
     "+", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", 
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.01"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{
     SuperscriptBox["\[Lambda]", "2"], "+", 
     RowBox[{"2", " ", "\[Mu]", " ", "\[Lambda]", " ", "x"}], "+", "\[Mu]", 
     "+", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{"x", "'"}], "==", 
    RowBox[{"\[Lambda]", "+", "\[Mu]", "+", 
     RowBox[{
      SuperscriptBox["\[Lambda]", "2"], " ", "x"}], "+", 
     RowBox[{"\[Mu]", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     SuperscriptBox["x", "3"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", 
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ",", "\[Mu]"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Bif2", "[", 
  RowBox[{"eq", ",", "unk", ",", "par"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"Bif2G", "[", 
  RowBox[{
  "eq", ",", "unk", ",", "par", ",", "1", ",", "1", ",", "50", ",", "0.01"}], 
  "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.9 The Program HopfBif", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 7.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"\[Epsilon]", " ", "x"}], "-", 
       RowBox[{"3", " ", "y"}], "+", 
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}], "3"]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"\[Epsilon]", " ", "y"}], "+", 
       RowBox[{"y", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}], "3"]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Epsilon]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "300"}], "]"}]}], "Input",
 CellChangeTimes->{{3.47678513115625*^9, 3.4767851320625*^9}},
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"x", "+", "y"}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Epsilon]", "-", "2"}], ")"}], "x"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Epsilon]", "-", "1"}], ")"}], "y"}], "-", 
       SuperscriptBox["x", "3"], "-", 
       RowBox[{
        SuperscriptBox["x", "2"], "y"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Epsilon]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "1000"}], "]"}]}], "Input",
 CellChangeTimes->{{3.476785138703125*^9, 3.476785148359375*^9}},
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 7.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"\[Lambda]", " ", "x"}], "+", "y", "-", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Lambda]", " ", "y"}], "-", 
       RowBox[{"y", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Lambda]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", "500"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7.10 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Lambda]", " ", "y"}], "-", 
       SuperscriptBox["y", "3"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Lambda]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"valpar", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"HopfBif", "[", 
   RowBox[{"sys", ",", "unk", ",", "par", ",", "valpar", ",", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}], ",", "500"}], "]"}], " "}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"\[Lambda]", " ", "x"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Lambda]", "-", "2"}], ")"}], "y"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", "-", "2"}], ")"}]}], "x"}], "+", 
       RowBox[{"\[Lambda]", "  ", "y"}], "-", 
       RowBox[{"y", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["y", "3"]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Lambda]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", "500"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"2", " ", "\[Lambda]", " ", "x"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Lambda]", "-", "1"}], ")"}], "y"}], "-", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", "+", "1"}], ")"}]}], "x"}], "+", 
       RowBox[{"2", " ", "\[Lambda]", " ", "y"}], "-", 
       RowBox[{"y", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Lambda]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", "500"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Lambda]", " ", "y"}], "-", 
       RowBox[{"y", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{"HopfBif", "[", 
  RowBox[{"sys", ",", "unk", ",", "\[Lambda]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", "500"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{
       RowBox[{"\[Lambda]", " ", "x"}], "+", "y", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", " ", "y"}], "+", 
          RowBox[{"x", " ", 
           SuperscriptBox["y", "2"]}]}], ")"}], "2"]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Lambda]", " ", "y"}], "-", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"unk", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"HopfBif", "[", 
   RowBox[{"sys", ",", "unk", ",", "\[Lambda]", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.0005", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}], ",", "1500"}], "]"}], " "}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1316, 899},
WindowMargins->{{14, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 216, 9, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[962, 42, 61, 1, 87, "Section"],
Cell[1026, 45, 543, 17, 36, "Text"],
Cell[1572, 64, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1786, 74, 145, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[1956, 80, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2070, 85, 406, 14, 124, "Input"],
Cell[2479, 101, 198, 6, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2714, 112, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2828, 117, 433, 15, 126, "Input"],
Cell[3264, 134, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3478, 144, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3592, 149, 670, 23, 129, "Input"],
Cell[4265, 174, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4479, 184, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4593, 189, 624, 21, 129, "Input"],
Cell[5220, 212, 177, 5, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5446, 223, 126, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[5597, 229, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[5712, 234, 433, 15, 126, "Input"],
Cell[6148, 251, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6362, 261, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[6477, 266, 504, 17, 126, "Input"],
Cell[6984, 285, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7198, 295, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[7313, 300, 573, 20, 130, "Input"],
Cell[7889, 322, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8103, 332, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[8218, 337, 435, 15, 126, "Input"],
Cell[8656, 354, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8870, 364, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[8985, 369, 482, 17, 126, "Input"],
Cell[9470, 388, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9684, 398, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[9799, 403, 516, 18, 157, "Input"],
Cell[10318, 423, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10532, 433, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[10647, 438, 576, 20, 165, "Input"],
Cell[11226, 460, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11440, 470, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[11555, 475, 488, 17, 149, "Input"],
Cell[12046, 494, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12260, 504, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[12375, 509, 592, 21, 129, "Input"],
Cell[12970, 532, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13184, 542, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[13300, 547, 551, 19, 129, "Input"],
Cell[13854, 568, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14068, 578, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[14184, 583, 574, 20, 129, "Input"],
Cell[14761, 605, 177, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14975, 615, 113, 3, 45, "Subsection",
 Evaluatable->False],
Cell[15091, 620, 580, 20, 129, "Input"],
Cell[15674, 642, 179, 5, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15902, 653, 145, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[16072, 659, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[16187, 664, 508, 17, 104, "Input"],
Cell[16698, 683, 193, 6, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16928, 694, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[17042, 699, 508, 17, 104, "Input"],
Cell[17553, 718, 27, 0, 35, "Input"],
Cell[17583, 720, 193, 6, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17825, 732, 126, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[17976, 738, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[18091, 743, 608, 20, 104, "Input"],
Cell[18702, 765, 193, 6, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18932, 776, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[19047, 781, 571, 19, 104, "Input"],
Cell[19621, 802, 193, 6, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19851, 813, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[19966, 818, 605, 20, 126, "Input"],
Cell[20574, 840, 193, 6, 35, "Input"],
Cell[20770, 848, 605, 20, 126, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21412, 873, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[21527, 878, 644, 21, 126, "Input"],
Cell[22174, 901, 193, 6, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22416, 913, 137, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[22578, 919, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[22692, 924, 1391, 46, 108, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24120, 975, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[24234, 980, 1156, 38, 107, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25427, 1023, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[25541, 1028, 1215, 41, 107, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26805, 1075, 127, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[26957, 1081, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[27071, 1086, 998, 34, 129, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28106, 1125, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[28220, 1130, 1195, 40, 107, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29452, 1175, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[29566, 1180, 1418, 47, 107, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31021, 1232, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[31135, 1237, 996, 34, 107, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32168, 1276, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[32282, 1281, 1257, 42, 108, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
